/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.voting;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.option.EJiraIssueUpdateCategory;
import com.teamscale.core.analysis.configuration.model.option.JiraIssueUpdateConfiguration;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.BaseUrlOption;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.rollback.PostRevisionAnalysisTriggerBase;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.jira.JiraBugTrackerConnectorDescriptor;
import com.teamscale.index.issues.jira.JiraConnectorUtils;
import com.teamscale.index.issues.jira.voting.ExtendedJiraIssueUpdateConfiguration;
import com.teamscale.index.issues.jira.voting.JiraIssueUpdater;
import com.teamscale.index.issues.jira.voting.JiraIssuesToUpdateCalculator;
import com.teamscale.index.issues.jira.voting.JiraVotingInput;
import com.teamscale.index.issues.jira.voting.JiraVotingInputCalculator;
import com.teamscale.index.issues.jira.voting.TeamscaleJiraMessageRow;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class JiraIssueUpdatePostAnalysisTrigger
extends PostRevisionAnalysisTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String JIRA_UPDATE_LOCK_PREFIX = "jira-update-lock_";

    public void execute() throws StorageException, ExecutionCanceledException {
        if (ShadowModeOption.isShadowModeEnabled((GlobalStorageSystem)this.openGlobalStorageSystem())) {
            String logMessage = "Skipping annotating Jira issues because shadow mode is enabled.";
            LogBuilder logBuilder = LOGGER.atInfo();
            if (this.isScheduledByDebugService()) {
                logBuilder = LOGGER.atWarn();
            }
            logBuilder.withMarker(LoggingUtils.INTERACTION).log(logMessage);
            return;
        }
        Optional<JiraBugTrackerConnectorDescriptor> connectorDescriptorOptional = this.loadConnectorDescriptor();
        if (connectorDescriptorOptional.isEmpty()) {
            LOGGER.debug("Could not load Jira connector descriptor. Skipping annotating Jira tickets.");
            return;
        }
        JiraBugTrackerConnectorDescriptor connectorDescriptor = connectorDescriptorOptional.get();
        Optional<JiraIssueUpdater> jiraClient = this.setupJiraClient(connectorDescriptor);
        if (jiraClient.isEmpty()) {
            LOGGER.debug("Could not create a Jira client from the loaded Jira connector descriptor.");
            return;
        }
        ExtendedJiraIssueUpdateConfiguration jiraIssueUpdateConfiguration = this.loadJiraConfiguration(connectorDescriptor);
        Set<TeamscaleIssueId> issuesToUpdate = this.determineIssueIdsToUpdate(jiraIssueUpdateConfiguration.getCategories());
        LOGGER.debug("Fetched {} issues to update: {}", (Object)issuesToUpdate.size(), issuesToUpdate);
        JiraVotingInputCalculator jiraVotingInputCalculator = new JiraVotingInputCalculator(this.indexLayer, (IProjectId)this.getProjectId(), LOGGER);
        Map<TeamscaleIssueId, JiraVotingInput> jiraVotingInputs = jiraVotingInputCalculator.calculateVotingInput(this.getSchedulingCommit(), issuesToUpdate, jiraIssueUpdateConfiguration, () -> ((JiraIssueUpdatePostAnalysisTrigger)this).verifyNotCanceled());
        if (jiraIssueUpdateConfiguration.shouldHideResolvedFindings()) {
            jiraVotingInputs.putAll(this.calculateIssuesAffectedByResolvedFindings(jiraVotingInputCalculator, jiraVotingInputs, jiraIssueUpdateConfiguration));
        }
        this.updateIssues(jiraClient.get(), jiraVotingInputs.values(), jiraIssueUpdateConfiguration);
    }

    private Map<TeamscaleIssueId, JiraVotingInput> calculateIssuesAffectedByResolvedFindings(JiraVotingInputCalculator jiraVotingInputCalculator, Map<TeamscaleIssueId, JiraVotingInput> jiraVotingInputs, ExtendedJiraIssueUpdateConfiguration jiraIssueUpdateConfiguration) throws ExecutionCanceledException {
        try {
            Set<TeamscaleIssueId> additionalIssuesToUpdate = JiraIssuesToUpdateCalculator.forResolvedFindings(this.openProjectStorageSystem(), jiraVotingInputs.values());
            return jiraVotingInputCalculator.calculateVotingInput(this.getSchedulingCommit(), additionalIssuesToUpdate, jiraIssueUpdateConfiguration, () -> ((JiraIssueUpdatePostAnalysisTrigger)this).verifyNotCanceled());
        }
        catch (StorageException e) {
            LOGGER.error("Error calculating related issues, falling back to empty list.", (Throwable)e);
            return CollectionUtils.emptyMap();
        }
    }

    private @NonNull ExtendedJiraIssueUpdateConfiguration loadJiraConfiguration(JiraBugTrackerConnectorDescriptor connectorDescriptor) throws StorageException {
        JiraIssueUpdateConfiguration issueUpdateConfiguration = connectorDescriptor.getIssueUpdateConfiguration();
        boolean hideResolvedFindings = JiraConnectorUtils.shouldHideResolveFindingsInBadges(this.openProjectStorageSystem(), LOGGER);
        return new ExtendedJiraIssueUpdateConfiguration(issueUpdateConfiguration, hideResolvedFindings);
    }

    @VisibleForTesting
    Set<TeamscaleIssueId> determineIssueIdsToUpdate(Set<EJiraIssueUpdateCategory> categories) throws StorageException {
        if (this.isScheduledByDebugService()) {
            Set<TeamscaleIssueId> teamscaleIssueIds = JiraIssuesToUpdateCalculator.forDebugService(this.getJobDescriptor());
            return (Set)IStreamWithException.wrap(teamscaleIssueIds.stream()).withException(StorageException.class).filter(this::issueExists).collect(Collectors.toSet());
        }
        return JiraIssuesToUpdateCalculator.forCommit(this.getSchedulingCommit(), categories, this.openProjectStorageSystem());
    }

    @VisibleForTesting
    protected boolean issueExists(TeamscaleIssueId teamscaleIssueId) throws StorageException {
        IssueIndex issueIndex = (IssueIndex)this.openIndexInProject(IssueIndex.class);
        if (issueIndex.getIssue(teamscaleIssueId) == null) {
            LOGGER.info("Issue {} does not exist in Teamscale. Skipping.", (Object)teamscaleIssueId);
            return false;
        }
        return true;
    }

    private void updateIssues(JiraIssueUpdater jiraClient, Collection<JiraVotingInput> jiraVotingInputs, ExtendedJiraIssueUpdateConfiguration jiraIssueUpdateConfiguration) throws StorageException, ExecutionCanceledException {
        IssueIndex issueIndex = (IssueIndex)this.openIndexInProject(IssueIndex.class);
        for (JiraVotingInput votingInput : jiraVotingInputs) {
            this.verifyNotCanceled();
            if (issueIndex.getIssue(votingInput.issueId()) == null) {
                LOGGER.debug("Could not find issue {} in the issue index. Skipping update!", (Object)votingInput.issueId());
                continue;
            }
            try {
                if (votingInput.isEmpty()) continue;
                this.updateIssueConcurrent(jiraClient, votingInput.issueId(), this.buildMessageForIssue(votingInput, jiraIssueUpdateConfiguration));
            }
            catch (ServiceCallException | BugTrackerException ex) {
                LOGGER.error("Unable to send data to Jira server. Skipping to next issue. ({}).", (Object)((Object)((Object)this)).getClass().getName(), (Object)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIssueConcurrent(JiraIssueUpdater jiraClient, TeamscaleIssueId issueId, TeamscaleJiraMessageRow message) throws BugTrackerException, ServiceCallException {
        String lockName = JIRA_UPDATE_LOCK_PREFIX + jiraClient.getJiraServerBaseUrl() + "_" + String.valueOf(issueId);
        Lock jiraUpdateLock = this.lockProvider.obtainLock(lockName);
        try {
            jiraUpdateLock.lock();
            jiraClient.updateIssue(issueId.getExternalId(), message);
        }
        finally {
            jiraUpdateLock.unlock();
        }
    }

    @VisibleForTesting
    TeamscaleJiraMessageRow buildMessageForIssue(JiraVotingInput votingInput, ExtendedJiraIssueUpdateConfiguration jiraIssueUpdateConfiguration) throws StorageException {
        PublicProjectId projectId = this.getPrimaryPublicId();
        String baseUrl = BaseUrlOption.getBaseUrl((ServerOptionIndex)((ServerOptionIndex)this.openGlobalIndex(ServerOptionIndex.class)));
        String projectName = ((ProjectIndex)this.openGlobalIndex(ProjectIndex.class)).findProjectName((IProjectId)projectId);
        return TeamscaleJiraMessageRow.create(votingInput, jiraIssueUpdateConfiguration, projectName, projectId, baseUrl);
    }

    @VisibleForTesting
    Optional<JiraBugTrackerConnectorDescriptor> loadConnectorDescriptor() throws StorageException {
        JiraBugTrackerConnectorDescriptor connectorDescriptor;
        try {
            connectorDescriptor = (JiraBugTrackerConnectorDescriptor)ConnectorUtils.loadIssueTrackerConnectorFromStorage((InternalProjectId)this.getProjectId(), (IndexLayer)this.getIndexLayer(), (EIssueTracker)EIssueTracker.JIRA);
        }
        catch (ProjectConfigurationException ex) {
            LOGGER.error("Could not load Jira connector configuration. Updating Jira issues not possible. ({}).", (Object)((Object)((Object)this)).getClass().getName(), (Object)ex);
            return Optional.empty();
        }
        return Optional.of(connectorDescriptor);
    }

    @VisibleForTesting
    Optional<JiraIssueUpdater> setupJiraClient(JiraBugTrackerConnectorDescriptor connectorDescriptor) throws StorageException {
        try {
            return Optional.of(new JiraIssueUpdater(connectorDescriptor, (ExternalCredentialsIndex)this.openGlobalIndex(ExternalCredentialsIndex.class)));
        }
        catch (ServiceCallException | BugTrackerException e) {
            LOGGER.error("Jira issue updater setup error.", e);
            return Optional.empty();
        }
    }

    @VisibleForTesting
    protected @Nullable CommitDescriptor getSchedulingCommit() {
        return this.jobDescriptor.getSchedulingCommit();
    }

    @VisibleForTesting
    protected JobDescriptor getJobDescriptor() {
        return this.jobDescriptor;
    }

    @VisibleForTesting
    boolean isScheduledByDebugService() {
        return this.getSchedulingCommit() == null;
    }

    public Set<String> getWriteStores() {
        return Set.of(JiraIssueUpdatePostAnalysisTrigger.class.getName());
    }

    public Set<String> getTransitiveWriteStores() {
        return this.getWriteStores();
    }

    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.PARALLEL;
    }
}

