/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.rtc;

import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.index.issues.BugTrackerConnectorDescriptorBase;
import com.teamscale.index.issues.IssueTrackerSynchronizerBase;
import com.teamscale.index.issues.rtc.RtcConnectorUtils;
import com.teamscale.index.issues.rtc.RtcIssueSynchronizer;
import java.util.Collections;
import java.util.List;

@ConnectorDescriptor
public class RtcBugTrackerConnectorDescriptor
extends BugTrackerConnectorDescriptorBase {
    private static final String ITEM_TYPES_PARAMETER_NAME = "Item types";
    private static final String ITEM_TYPES_PARAMETER_DESCRIPTION = "The types of work items to retrieve. Leave empty for all item types.";
    @ConfigExposed(name="Item types", description="The types of work items to retrieve. Leave empty for all item types.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    private List<String> itemTypes = Collections.emptyList();
    @ConfigExposed(name="Field filter expression", visibility=ConfigExposed.EConfigVisibility.EXPERT, description="A pattern to filter work items based on their fields. This is sent to the Reportable REST API and will be concatenated with a logical AND to any existing filters.")
    protected String additionalFieldFilter = null;

    public RtcBugTrackerConnectorDescriptor() {
        super(EIssueTracker.RTC);
        this.autoExpose();
    }

    @Override
    protected Class<? extends IssueTrackerSynchronizerBase<?>> getIssueTrackerSynchronizerClass() {
        return RtcIssueSynchronizer.class;
    }

    @Override
    protected void configureAdditionalIssueTrackerParameters(TriggerBuilder issueTrackerTriggerBuilder) throws ProjectConfigurationException {
        super.configureAdditionalIssueTrackerParameters(issueTrackerTriggerBuilder);
        issueTrackerTriggerBuilder.setTriggerParameter("field-filter", this.additionalFieldFilter);
        issueTrackerTriggerBuilder.setTriggerParameter("item-type", ITriggerParameter.of(this.itemTypes));
    }

    protected boolean shouldStripTrailingSlashFromUrl() {
        return true;
    }

    public void validateAccountDetails(String url, String username, String password) throws ConnectorValidationException {
        RtcConnectorUtils.validateAccountDetails(url, username, password);
    }
}

