/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.rtc.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.teamscale.commons.service.XmlSerializationUtils;
import com.teamscale.index.issues.rtc.client.model.RtcPaginatedWorkItemList;
import com.teamscale.index.issues.rtc.client.model.RtcWorkItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class RtcWorkItemParser {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String WORK_ITEM_KEY = "workItem";
    private static final String HREF_KEY = "href";
    private static final String ITEM_HISTORY_KEY = "itemHistory";
    private static final ObjectReader JSON_READER = JsonUtils.getObjectMapper().readerFor(RtcWorkItem.class).with(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT).with(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);

    public static RtcPaginatedWorkItemList parseWorkItemList(String xml, PairList<String, Boolean> customFields) throws IOException, JsonSerializationException {
        JsonNode workItemListResult = XmlSerializationUtils.parseXmlToJsonNode((String)xml);
        List<RtcWorkItem> workItems = RtcWorkItemParser.parseWorkItemsFromWrapperNode(workItemListResult, customFields, WORK_ITEM_KEY);
        JsonNode hrefNode = workItemListResult.get(HREF_KEY);
        String href = "";
        if (hrefNode != null && hrefNode.isTextual()) {
            href = hrefNode.asText();
        }
        return new RtcPaginatedWorkItemList(href, workItems);
    }

    public static List<RtcWorkItem> parseWorkItemHistory(String xml, PairList<String, Boolean> customFields) throws IOException, JsonSerializationException {
        if (StringUtils.isEmpty((String)xml)) {
            return Collections.emptyList();
        }
        JsonNode workItemHistoryResult = XmlSerializationUtils.parseXmlToJsonNode((String)xml);
        JsonNode workItemNode = workItemHistoryResult.get(WORK_ITEM_KEY);
        if (workItemNode == null) {
            return Collections.emptyList();
        }
        return RtcWorkItemParser.parseWorkItemsFromWrapperNode(workItemNode, customFields, ITEM_HISTORY_KEY);
    }

    private static List<RtcWorkItem> parseWorkItemsFromWrapperNode(JsonNode workItemWrapperNode, PairList<String, Boolean> customFields, String workItemNodesName) throws JsonSerializationException {
        List<JsonNode> workItemJsonNodes = RtcWorkItemParser.extractSingleWorkItemNodes(workItemWrapperNode, workItemNodesName);
        return CollectionUtils.mapWithException(workItemJsonNodes, workItemNode -> RtcWorkItemParser.parseWorkItem(workItemNode, customFields));
    }

    private static List<JsonNode> extractSingleWorkItemNodes(JsonNode workItemWrapperNode, String workItemNodesName) {
        JsonNode workItemsNode = workItemWrapperNode.get(workItemNodesName);
        if (workItemsNode == null) {
            return Collections.emptyList();
        }
        if (workItemsNode.isArray()) {
            ArrayList<JsonNode> jsonNodes = new ArrayList<JsonNode>();
            for (int i = 0; i < workItemsNode.size(); ++i) {
                JsonNode workItemNode = workItemsNode.get(i);
                if (!RtcWorkItemParser.checkWorkItemNodeIsObject(workItemNode)) continue;
                jsonNodes.add(workItemNode);
            }
            return jsonNodes;
        }
        if (RtcWorkItemParser.checkWorkItemNodeIsObject(workItemsNode)) {
            return List.of(workItemsNode);
        }
        return Collections.emptyList();
    }

    private static boolean checkWorkItemNodeIsObject(JsonNode workItemNode) {
        if (!workItemNode.isObject()) {
            LOGGER.warn("Expected json object but found {}. Ignoring this work item.", (Object)workItemNode);
            return false;
        }
        return true;
    }

    private static RtcWorkItem parseWorkItem(JsonNode workItemNode, PairList<String, Boolean> customFields) throws JsonSerializationException {
        RtcWorkItem workItem;
        try {
            workItem = (RtcWorkItem)JSON_READER.readValue(workItemNode);
        }
        catch (IOException e) {
            throw new JsonSerializationException("Input was invalid JSON.", (Throwable)e);
        }
        List allExtensionsNodes = workItemNode.findParents("displayName");
        for (Pair customField : customFields) {
            String value = (Boolean)customField.getSecond() != false ? RtcWorkItemParser.getUserDefinedCustomFieldValue(allExtensionsNodes, workItem.getId(), (String)customField.getFirst()) : RtcWorkItemParser.getStandardCustomFieldValue(workItemNode, workItem.getId(), (String)customField.getFirst());
            workItem.addCustomField(StringUtils.capitalize((String)((String)customField.getFirst())), value);
        }
        return workItem;
    }

    private static String getUserDefinedCustomFieldValue(List<JsonNode> allExtensionsNodes, long workItemId, String customFieldName) {
        JsonNode extension = RtcWorkItemParser.findExtensionNodeForDisplayName(allExtensionsNodes, customFieldName);
        if (extension == null) {
            RtcWorkItemParser.logMissingCustomField(workItemId, customFieldName);
            return "";
        }
        JsonNode displayValue = extension.get("displayValue");
        if (displayValue == null || !displayValue.isValueNode()) {
            LOGGER.warn("Custom field '{}' has no value in work item '{}'. Skipping this custom field.", (Object)customFieldName, (Object)workItemId);
            return "";
        }
        return displayValue.asText();
    }

    private static JsonNode findExtensionNodeForDisplayName(List<JsonNode> allExtensionsNodes, String customFieldName) {
        if (allExtensionsNodes == null) {
            return null;
        }
        for (JsonNode extension : allExtensionsNodes) {
            JsonNode displayName = extension.get("displayName");
            if (!displayName.isValueNode() || !displayName.asText().equals(customFieldName)) continue;
            return extension;
        }
        return null;
    }

    private static String getStandardCustomFieldValue(JsonNode workItemNode, long workItemId, String customFieldName) {
        JsonNode customFieldNode = workItemNode.get(customFieldName);
        if (customFieldNode == null) {
            RtcWorkItemParser.logMissingCustomField(workItemId, customFieldName);
            return "";
        }
        if (customFieldNode.isValueNode()) {
            return customFieldNode.asText();
        }
        JsonNode valueNode = customFieldNode.get("name");
        if (valueNode == null || !valueNode.isValueNode()) {
            LOGGER.warn("Custom field '{}' has no 'name' value field in work item '{}'. Skipping this custom field.", (Object)customFieldName, (Object)workItemId);
            return "";
        }
        return valueNode.asText();
    }

    private static void logMissingCustomField(long workItemId, String customFieldName) {
        LOGGER.warn("Work item '{}' has no custom field '{}'. Skipping this custom field.", (Object)workItemId, (Object)customFieldName);
    }
}

