/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.merge_request;

import com.teamscale.core.analysis.configuration.index.model.EvaluatedMetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdBase;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdGroup;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdIdentifier;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.metrics.values.IMetricValue;
import com.teamscale.core.metrics.values.MetricValueBase;
import com.teamscale.index.metrics.assessment.ETrend;
import com.teamscale.index.metrics.assessment.GroupAssessment;
import com.teamscale.index.metrics.assessment.MetricAssessment;
import com.teamscale.index.metrics.assessment.TrendDelta;
import com.teamscale.index.metrics.assessment.computation.IMetricComputation;
import com.teamscale.index.metrics.assessment.computation.MetricComputationBase;
import com.teamscale.index.metrics.assessment.context.IMetricEvaluationContext;
import com.teamscale.index.metrics.assessment.context.MetricDataRetrieverFactory;
import com.teamscale.index.metrics.assessment.context.MetricEvaluationContext;
import com.teamscale.index.metrics.assessment.context.NonCodeMetricEvaluationContext;
import com.teamscale.index.metrics.threshold.MetricThresholdEvaluator;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;

public class MetricAssessmentComputation {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MetricThresholdEvaluator thresholdEvaluator;
    private final MetricDataRetrieverFactory metricDataRetrieverFactory;
    private final ProjectStorageSystem projectStorage;
    private final IParallelTaskExecutor parallelTaskExecutor;

    public MetricAssessmentComputation(MetricThresholdEvaluator thresholdEvaluator, MetricDataRetrieverFactory metricDataRetrieverFactory, ProjectStorageSystem projectStorage, IParallelTaskExecutor parallelTaskExecutor) {
        this.metricDataRetrieverFactory = Objects.requireNonNull(metricDataRetrieverFactory, "metricDataRetrieverFactory");
        this.thresholdEvaluator = Objects.requireNonNull(thresholdEvaluator, "thresholdEvaluator");
        this.projectStorage = Objects.requireNonNull(projectStorage, "projectStorage");
        this.parallelTaskExecutor = Objects.requireNonNull(parallelTaskExecutor, "parallelTaskExecutor");
    }

    public List<GroupAssessment> computeAssessment(String uniformPath, HistoryAccessOption historyAccessOption, @Nullable HistoryAccessOption baselineHistoryOption, boolean usePartitionDelta) throws StorageException, MetricThresholdConfigurationException {
        MetricEvaluationContext evaluationContext = new MetricEvaluationContext(uniformPath, this.metricDataRetrieverFactory);
        if (usePartitionDelta) {
            evaluationContext = new NonCodeMetricEvaluationContext(uniformPath, this.metricDataRetrieverFactory, this.projectStorage);
        }
        evaluationContext.setCurrentHistoryAccessOption(historyAccessOption);
        evaluationContext.setBaselineHistoryAccessOption(baselineHistoryOption);
        if (!evaluationContext.doesMetricDirectoryEntryExistAtCurrentAccessOption()) {
            return CollectionUtils.emptyList();
        }
        return this.createMetricGroupAssessmentResult(evaluationContext);
    }

    public Optional<MetricAssessment> computeSingleAssessment(String uniformPath, MetricThresholdIdentifier thresholdIdentifier, HistoryAccessOption historyAccessOption) throws StorageException, MetricThresholdConfigurationException {
        MetricEvaluationContext evaluationContext = new MetricEvaluationContext(uniformPath, this.metricDataRetrieverFactory);
        evaluationContext.setCurrentHistoryAccessOption(historyAccessOption);
        if (!evaluationContext.doesMetricDirectoryEntryExistAtCurrentAccessOption()) {
            return Optional.empty();
        }
        return Optional.of(this.createMetricAssessmentResult(evaluationContext, thresholdIdentifier));
    }

    private List<GroupAssessment> createMetricGroupAssessmentResult(IMetricEvaluationContext evaluationContext) throws MetricThresholdConfigurationException {
        List thresholdGroups = this.thresholdEvaluator.getThresholdConfiguration().computeTransitiveMetricThresholdGroups();
        Map resultByGroupName = Collections.synchronizedMap(new LinkedHashMap(thresholdGroups.size()));
        thresholdGroups.forEach(group -> resultByGroupName.put(group.getName(), null));
        try {
            this.parallelTaskExecutor.processInParallelBatches(thresholdGroups, thresholdGroupsInBatch -> {
                for (MetricThresholdGroup thresholdGroup : thresholdGroupsInBatch) {
                    resultByGroupName.put(thresholdGroup.getName(), this.createMetricGroupAssessment(thresholdGroup, evaluationContext));
                }
            }, 1);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MetricThresholdConfigurationException("Error during metric calculation", (Throwable)e);
        }
        return resultByGroupName.values().stream().toList();
    }

    private GroupAssessment createMetricGroupAssessment(MetricThresholdGroup thresholdGroup, IMetricEvaluationContext evaluationContext) throws MetricThresholdConfigurationException {
        List<MetricAssessment> thresholdAssessments = Collections.synchronizedList(new ArrayList());
        try {
            this.parallelTaskExecutor.processInParallelBatches((List)thresholdGroup.getMetricThresholdList(), thresholdGroupsInBatch -> {
                for (MetricThreshold metricThreshold : thresholdGroupsInBatch) {
                    MetricAssessment thresholdAssessment = this.createMetricAssessmentResult(evaluationContext, metricThreshold, thresholdGroup);
                    thresholdAssessments.add(thresholdAssessment);
                }
            }, 1);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MetricThresholdConfigurationException("Error during metric computation", (Throwable)e);
        }
        ETrafficLightColor groupRating = MetricAssessmentComputation.aggregateToGroupAssessment(thresholdAssessments);
        return new GroupAssessment(thresholdGroup.getName(), groupRating, thresholdAssessments);
    }

    private MetricAssessment createMetricAssessmentResult(IMetricEvaluationContext evaluationContext, MetricThreshold metricThreshold, MetricThresholdGroup metricThresholdGroup) throws MetricThresholdConfigurationException {
        MetricThresholdIdentifier thresholdIdentifier = new MetricThresholdIdentifier(metricThresholdGroup, metricThreshold);
        return this.createMetricAssessmentResult(evaluationContext, thresholdIdentifier);
    }

    public MetricAssessment createMetricAssessmentResult(IMetricEvaluationContext evaluationContext, MetricThresholdIdentifier metricThresholdIdentifier) throws MetricThresholdConfigurationException {
        String thresholdDisplayName = metricThresholdIdentifier.getThresholdDisplayName();
        Optional<EvaluatedMetricThreshold> evaluatedMetricThreshold = this.thresholdEvaluator.evaluateThreshold(thresholdDisplayName, metricThresholdIdentifier.getGroupName());
        if (evaluatedMetricThreshold.isEmpty()) {
            throw new MetricThresholdConfigurationException("Evaluation of threshold failed: " + metricThresholdIdentifier.getThresholdDisplayName() + " of group " + metricThresholdIdentifier.getGroupName());
        }
        try {
            return MetricAssessmentComputation.createMetricAssessment(evaluationContext, evaluatedMetricThreshold.get());
        }
        catch (StorageException e) {
            throw new MetricThresholdConfigurationException("Assessment computation failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private static MetricAssessment createMetricAssessment(IMetricEvaluationContext evaluationContext, EvaluatedMetricThreshold threshold) throws StorageException {
        String metricName = threshold.getMetricName();
        Optional<MetricDirectorySchemaEntry> metricDirectorySchemaEntry = evaluationContext.getMetricDirectorySchemaEntry((MetricThresholdBase)threshold);
        if (metricDirectorySchemaEntry.isEmpty()) {
            return MetricAssessmentComputation.createAssessmentForUnavailableMetric(metricName, threshold, "Metric not available");
        }
        MetricValueBase currentValue = MetricValueBase.createWithOptional((MetricDirectorySchemaEntry)metricDirectorySchemaEntry.get(), evaluationContext.getMetricValueAtCurrentHistoryAccessOption(threshold));
        if (!currentValue.isValuePresent()) {
            return MetricAssessmentComputation.handleMissingValue(evaluationContext, threshold, metricName);
        }
        MetricValueBase baselineValue = MetricValueBase.createWithOptional((MetricDirectorySchemaEntry)metricDirectorySchemaEntry.get(), evaluationContext.getMetricValueAtBaselineHistoryAccessOption(threshold));
        return MetricAssessmentComputation.createMetricAssessment(threshold, currentValue, baselineValue);
    }

    private static MetricAssessment handleMissingValue(IMetricEvaluationContext evaluationContext, EvaluatedMetricThreshold threshold, String metricName) {
        String currentPath = evaluationContext.getThresholdPath(threshold);
        Object message = String.format("Metric '%s' not available for path: %s", metricName, currentPath);
        if (MetricAssessmentComputation.shouldExpectMetricIsAvailable(currentPath)) {
            message = evaluationContext instanceof NonCodeMetricEvaluationContext ? (String)message + " No data has been uploaded for the current commit." : (String)message + " It was likely disabled for the path or not part of the code-scope.";
            LOGGER.info((String)message);
        }
        return MetricAssessmentComputation.createAssessmentForUnavailableMetric(metricName, threshold, (String)message);
    }

    private static boolean shouldExpectMetricIsAvailable(String currentPath) {
        return !currentPath.equals("-architecture-files-") && !currentPath.equals(ArchitectureMetricsUtils.ROOT_PATH_TO_ARCHITECTURES);
    }

    private static MetricAssessment createMetricAssessment(EvaluatedMetricThreshold threshold, IMetricValue<?> currentValue, IMetricValue<?> baselineValue) {
        CCSMAssert.isNotNull((Object)threshold);
        CCSMAssert.isTrue((boolean)currentValue.isValuePresent(), (String)"value is missing");
        IMetricComputation<?> computationLogic = MetricComputationBase.createInstance(currentValue);
        ETrend trend = computationLogic.computeTrend(threshold, currentValue.getRawValue(), baselineValue.getOrNull());
        TrendDelta trendDelta = null;
        if (baselineValue.isValuePresent()) {
            trendDelta = computationLogic.computeTrendDelta(currentValue.getRawValue(), baselineValue.getOrNull());
        }
        ETrafficLightColor metricRating = computationLogic.computeMetricRating(threshold, currentValue.getRawValue());
        ETrafficLightColor baselineMetricRating = computationLogic.computeMetricRating(threshold, baselineValue.getOrNull());
        return new MetricAssessment(currentValue, metricRating, baselineMetricRating, trend, trendDelta, threshold);
    }

    private static MetricAssessment createAssessmentForUnavailableMetric(String metricName, EvaluatedMetricThreshold metricThreshold, String assessmentDescription) {
        return new MetricAssessment(new MetricDirectorySchemaEntry(metricName, assessmentDescription, MetricDirectorySchemaEntry.EAggregation.SUM, EMetricValueType.NUMERIC, EnumSet.noneOf(EMetricProperty.class)), null, ETrend.NA, ETrafficLightColor.UNKNOWN, ETrafficLightColor.UNKNOWN, TrendDelta.NOT_AVAILABLE, false, metricThreshold);
    }

    private static ETrafficLightColor aggregateToGroupAssessment(List<MetricAssessment> metrics) {
        return metrics.stream().map(MetricAssessment::getRating).filter(Objects::nonNull).reduce(ETrafficLightColor.UNKNOWN, ETrafficLightColor::getDominantColor);
    }
}

