/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metrics.assessment.context;

import com.teamscale.core.analysis.configuration.index.model.EMetricSchemaSource;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.user.User;
import com.teamscale.index.metrics.assessment.context.MetricDataRetriever;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;

public class MetricDataRetrieverFactory {
    private final Map<EMetricSchemaSource, MetricDataRetriever> metricDataRetrieverBySchemaSource = new EnumMap<EMetricSchemaSource, MetricDataRetriever>(EMetricSchemaSource.class);

    public MetricDataRetrieverFactory(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, MetricSchemaRetrieverFactory schemaRetrieverFactory) {
        this(null, projectStorageSystem, globalStorageSystem, currentUser, schemaRetrieverFactory);
    }

    public MetricDataRetrieverFactory(@Nullable Set<String> partitions, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, MetricSchemaRetrieverFactory schemaRetrieverFactory) {
        for (EMetricSchemaSource metricSchemaSource : EMetricSchemaSource.values()) {
            IMetricRetrievalStrategy strategy = MetricRetrievalStrategyFactory.getStrategy(metricSchemaSource.getPathType(), partitions, projectStorageSystem, globalStorageSystem, currentUser, schemaRetrieverFactory, false);
            this.metricDataRetrieverBySchemaSource.put(metricSchemaSource, new MetricDataRetriever(strategy));
        }
    }

    public MetricDataRetriever get(EMetricSchemaSource sourceType) {
        return this.metricDataRetrieverBySchemaSource.get(sourceType);
    }
}

