/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.utils.SerializationMigrationUtils;
import org.conqat.lib.commons.string.StringUtils;

public class ClassNameMigrator {
    private static final String TEAMSCALE_MIGRATION_PACKAGE_PREFIX = "com.teamscale.index.migration";
    private static final Pattern PRIMITIVE_TYPE_PATTERN = Pattern.compile("\\[*[A-Z]");
    private final PairList<String, String> intermediateClasses = new PairList();
    private final PairList<String, String> unmigratedClasses = new PairList();
    private final PairList<String, String> migratedClasses = new PairList();

    public void registerIntermediateClass(String fullyQualifiedClassName, Class<?> intermediateClass) {
        String originalSimpleClassName = StringUtils.getLastPart((String)StringUtils.getLastPart((String)fullyQualifiedClassName, (char)'.'), (char)'$');
        CCSMAssert.isTrue((boolean)intermediateClass.getSimpleName().endsWith(originalSimpleClassName), (String)(String.valueOf(intermediateClass) + " does not end with " + originalSimpleClassName));
        this.intermediateClasses.add((Object)fullyQualifiedClassName, (Object)intermediateClass.getName());
    }

    public void registerMigratedClass(String newClassName, Class<?> migratedClass) {
        this.migratedClasses.add((Object)newClassName, (Object)migratedClass.getName());
    }

    public void registerUnmigratedClass(String oldClassName, Class<?> unmigratedClass) {
        this.unmigratedClasses.add((Object)oldClassName, (Object)unmigratedClass.getName());
    }

    public void renameToIntermediateNames(SerializedEntityPool entityPool) {
        for (Pair intermediateClassPair : this.intermediateClasses) {
            entityPool.renameClass((String)intermediateClassPair.getFirst(), (String)intermediateClassPair.getSecond());
        }
        for (Pair unmigratedClassPair : this.unmigratedClasses) {
            entityPool.renameClass((String)unmigratedClassPair.getFirst(), (String)unmigratedClassPair.getSecond());
        }
    }

    public byte[] serialize(Serializable serializable) throws StorageException {
        try {
            byte[] serializedValue = SerializationUtils.serializeToByteArray((Serializable)serializable);
            SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])serializedValue);
            entityPool.assertAllPlainClassNamesMatch(className -> ClassNameMigrator.isJavaType(className) || className.startsWith(TEAMSCALE_MIGRATION_PACKAGE_PREFIX), "Class name not allowed during serialization before rename");
            this.renameToSerializableNames(entityPool);
            entityPool.assertAllPlainClassNamesMatch(className -> ClassNameMigrator.isJavaType(className) || !className.startsWith(TEAMSCALE_MIGRATION_PACKAGE_PREFIX), "Class name not allowed during serialization after rename");
            return SerializedEntitySerializer.serializeToBytes((List)entityPool.getRootEntities());
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private static boolean isJavaType(String className) {
        return className.startsWith("java.") || PRIMITIVE_TYPE_PATTERN.matcher(className).matches();
    }

    private void renameToSerializableNames(SerializedEntityPool entityPool) {
        for (Pair intermediateClassPair : this.intermediateClasses) {
            entityPool.renameClass((String)intermediateClassPair.getSecond(), (String)intermediateClassPair.getFirst());
        }
        for (Pair migratedClassPair : this.migratedClasses) {
            entityPool.renameClass((String)migratedClassPair.getSecond(), (String)migratedClassPair.getFirst());
        }
    }

    public <T extends Serializable> T deserialize(byte[] value) throws StorageException {
        try {
            SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])value);
            this.renameToIntermediateNames(entityPool);
            entityPool.assertAllPlainClassNamesMatch(className -> ClassNameMigrator.isJavaType(className) || className.startsWith(TEAMSCALE_MIGRATION_PACKAGE_PREFIX), "Class name not allowed during deserialization after rename");
            return (T)((Serializable)SerializationMigrationUtils.serializeRootEntities((SerializedEntityPool)entityPool));
        }
        catch (IOException | ClassNotFoundException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public String getSerializedClassName(Class<?> clazz) {
        String className = clazz.getName();
        for (Pair intermediateClassPair : this.intermediateClasses) {
            if (!((String)intermediateClassPair.getSecond()).equals(className)) continue;
            return (String)intermediateClassPair.getFirst();
        }
        for (Pair migratedClassPair : this.migratedClasses) {
            if (!((String)migratedClassPair.getSecond()).equals(className)) continue;
            return (String)migratedClassPair.getFirst();
        }
        return className;
    }
}

