/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration;

import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IPointwiseStorageMigrator;
import java.util.Arrays;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion166UserIndex
implements IPointwiseStorageMigrator {
    private static final byte[] OLD_ENABLED_USERS_COUNT_KEY = StringUtils.stringToBytes((String)"###enabled-users###");
    private static final byte[] NEW_ENABLED_USERS_COUNT_RAW_KEY = ByteArrayUtils.concat((byte[][])new byte[][]{StringUtils.stringToBytes((String)"enabled-users$%$"), ByteArrayUtils.intToByteArray((int)0)});
    private static final byte[] NEW_VALUE_PREFIX = StringUtils.stringToBytes((String)"users$%$");
    private static final EStorageSystemVersion VERSION = EStorageSystemVersion.STORAGE_SYSTEM_V166;

    public PairList<byte[], byte[]> migrate(byte[] key, byte[] value) throws StorageException {
        byte[] newKey = Arrays.equals(OLD_ENABLED_USERS_COUNT_KEY, key) ? NEW_ENABLED_USERS_COUNT_RAW_KEY : ByteArrayUtils.concat((byte[][])new byte[][]{NEW_VALUE_PREFIX, key});
        return PairList.from((Object)newKey, (Object)value);
    }

    public String getStoreName() {
        return "users";
    }

    public EStorageSystemVersion getVersion() {
        return VERSION;
    }

    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }
}

