/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v123_compile_commands;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;

public class V123TeamscaleIssue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private V123TeamscaleIssueId id;
    private String subject;
    private String assignee;
    private String author;
    private String description;
    private long created;
    private long updated;
    private String url;
    private ArrayList<String> additionalFieldNames;
    private ArrayList<String> additionalFieldValues;
    private String status;
    private boolean closed;
    private V123TeamscaleIssueId parentId;

    public V123TeamscaleIssue(V123TeamscaleIssue issue) {
        this.id = issue.id;
        this.subject = issue.subject;
        this.assignee = issue.assignee;
        this.author = issue.author;
        this.description = issue.description;
        this.created = issue.created;
        this.updated = issue.updated;
        this.status = issue.status;
        this.closed = issue.closed;
        this.url = issue.url;
        this.additionalFieldNames = new ArrayList<String>(issue.additionalFieldNames);
        this.additionalFieldValues = new ArrayList<String>(issue.additionalFieldValues);
        this.parentId = issue.parentId;
    }

    protected V123TeamscaleIssue(@JsonProperty(value="id") V123TeamscaleIssueId id, @JsonProperty(value="subject") String subject, @JsonProperty(value="assignee") String assignee, @JsonProperty(value="author") String author, @JsonProperty(value="description") String description, @JsonProperty(value="created") long created, @JsonProperty(value="updated") long updated, @JsonProperty(value="status") String status, @JsonProperty(value="closed") boolean closed, @JsonProperty(value="url") String url, @JsonProperty(value="additionalFieldNames") List<String> additionalFieldNames, @JsonProperty(value="additionalFieldValues") List<String> additionalFieldValues, @JsonProperty(value="parentId") @Nullable V123TeamscaleIssueId parentId) {
        CCSMAssert.isNotNull((Object)id, (String)"An issue's ID must not be null or the empty string");
        this.id = id;
        this.subject = StringUtils.emptyIfNull((String)subject).trim();
        this.assignee = StringUtils.emptyIfNull((String)assignee).trim();
        this.author = StringUtils.emptyIfNull((String)author).trim();
        this.description = StringUtils.emptyIfNull((String)description).trim();
        this.created = created;
        this.updated = updated;
        this.status = StringUtils.emptyIfNull((String)status).trim();
        this.closed = closed;
        this.url = StringUtils.emptyIfNull((String)url).trim();
        CCSMAssert.isTrue((additionalFieldNames.size() == additionalFieldValues.size() ? 1 : 0) != 0, (String)"Lists for names and values of additional fields must have same length");
        this.additionalFieldNames = new ArrayList<String>(additionalFieldNames);
        this.additionalFieldValues = additionalFieldValues.stream().map(value -> value == null ? null : value.trim()).collect(Collectors.toCollection(ArrayList::new));
        this.parentId = parentId;
    }

    public V123TeamscaleIssueId getId() {
        return this.id;
    }

    public V123TeamscaleIssue(V123TeamscaleIssueId id, String subject, String assignee, String author, String description, long created, long updated, String status, boolean closed, String url, List<String> additionalFieldNames, List<String> additionalFieldValues, String parentId) {
        this(id, subject, assignee, author, description, created, updated, status, closed, url, additionalFieldNames, additionalFieldValues, V123TeamscaleIssue.calculateParentTeamscaleId(id, parentId));
    }

    private static V123TeamscaleIssueId calculateParentTeamscaleId(V123TeamscaleIssueId id, String parentId) {
        if (id == null || parentId == null || parentId.isEmpty()) {
            return null;
        }
        return id.withExternalId(parentId);
    }

    public static class V123TeamscaleIssueId
    implements Serializable {
        public static final String SEPARATOR = "|";
        private static final long serialVersionUID = 1L;
        private String internalId;
        private String connectorId;
        private String externalId;

        public V123TeamscaleIssueId(String connectorId, String externalId) {
            this.connectorId = connectorId;
            this.externalId = externalId;
            this.internalId = V123TeamscaleIssueId.computeInternalId(connectorId, externalId);
        }

        public V123TeamscaleIssueId withExternalId(String externalId) {
            return new V123TeamscaleIssueId(this.connectorId, externalId);
        }

        public static String computeInternalId(String connectorId, String externalId) {
            CCSMAssert.isFalse((boolean)connectorId.contains(SEPARATOR), () -> String.format("Connector ID \"%s\" must not contain \"%s\"", connectorId, SEPARATOR));
            return connectorId + SEPARATOR + externalId;
        }
    }
}

