/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications;

import com.teamscale.core.user.User;
import com.teamscale.index.notifications.INotificationRules;
import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.notifications.NotifierBase;
import com.teamscale.index.user.UserAliasLookup;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

public abstract class UserNotifierBase<T extends INotificationRules<?>>
extends NotifierBase {
    private static final Logger LOGGER = LogManager.getLogger();

    protected UserNotifierBase(NotificationContext notificationContext, UserAliasLookup userAliasLookup) {
        super(notificationContext, userAliasLookup);
    }

    @Override
    public void checkRulesAndNotify() throws StorageException {
        this.initialize();
        this.sendMailsToQualifyingUsers();
    }

    private void sendMailsToQualifyingUsers() throws StorageException {
        PairList<String, T> allNotificationEntries = this.getAllNotificationEntries();
        for (int i = 0; i < allNotificationEntries.size(); ++i) {
            String username = (String)allNotificationEntries.getFirst(i);
            Optional<User> user = this.userAliasLookup.resolveUser(username);
            if (user.isEmpty()) {
                LOGGER.debug("User with username {} not found", (Object)username);
                continue;
            }
            PublicProjectId projectId = this.notificationContext.getPrimaryPublicId();
            if (!this.mayAccessProject(user.get(), (IProjectId)projectId)) {
                LOGGER.debug("Excluding user {} from notifications about project {} due to missing access rights", user, (Object)projectId);
                continue;
            }
            this.processRules(user.get(), (INotificationRules)allNotificationEntries.getSecond(i));
        }
    }

    protected abstract void processRules(User var1, T var2) throws StorageException;

    protected abstract PairList<String, T> getAllNotificationEntries() throws StorageException;

    protected abstract void initialize() throws StorageException;
}

