/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.base;

import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoFindings;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.report.parser.ReportParserBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public abstract class FindingCollectingReportParserBase
extends ReportParserBase {
    private final Map<String, List<DetachedFinding>> findingsByPath = new HashMap<String, List<DetachedFinding>>();
    private String reportContent;

    protected final void initializeFindingsListForPath(String uniformPath) {
        this.findingsByPath.computeIfAbsent(uniformPath, k -> new ArrayList());
    }

    protected final void addFindingForPath(String path, DetachedFinding finding) {
        this.findingsByPath.computeIfAbsent(path, k -> new ArrayList()).add(finding);
    }

    @Override
    public void initializeState(String report) {
        this.reportContent = report;
    }

    @Override
    protected final ExternalAnalysisImportInfos convertToImportInfos() throws StorageException {
        this.collectFindings();
        if (this.findingsByPath.isEmpty() && !this.expectEmptyFindings() && !StringUtils.isEmpty((String)this.reportContent)) {
            LOGGER.warn("No findings found. Please check report format: {}", (Object)StringUtils.truncateWithEllipsis((String)this.reportContent, (int)200));
        }
        return new ExternalAnalysisImportInfos(CollectionUtils.map(this.findingsByPath.entrySet(), entry -> new ExternalAnalysisImportInfoFindings((String)entry.getKey(), (List)entry.getValue())));
    }

    protected boolean expectEmptyFindings() {
        return false;
    }

    public static DetachedFinding createLineFinding(int lineNumber, String uniformPath, String ruleId, String categoryName, String message) {
        if (lineNumber < 1) {
            lineNumber = 1;
        }
        TextRegionLocation location = FindingCollectingReportParserBase.createLineLocation(uniformPath, lineNumber);
        return FindingCollectingReportParserBase.createFindingWithLocation(ruleId, ruleId, categoryName, message, (ElementLocation)location);
    }

    protected static DetachedFinding createFileFinding(String uniformPath, String ruleId, String categoryName, String message) {
        return FindingCollectingReportParserBase.createFindingWithLocation(ruleId, ruleId, categoryName, message, new ElementLocation(uniformPath));
    }

    protected static TextRegionLocation createLineLocation(String uniformPath, int lineNumber) {
        return FindingCollectingReportParserBase.createLineLocation(uniformPath, lineNumber, lineNumber);
    }

    protected static TextRegionLocation createLineLocation(String uniformPath, int startLineNumber, int endLineNumber) {
        return new TextRegionLocation(uniformPath, -1, -1, startLineNumber, endLineNumber);
    }

    protected abstract void collectFindings() throws StorageException;
}

