/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.generic;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.string.StringUtils;

public class ExternalFindingData {
    @JsonProperty(value="findingTypeId")
    private String findingTypeId;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="assessment")
    private @Nullable ETrafficLightColor assessment = null;
    @JsonProperty(value="startOffset")
    private @Nullable Integer startOffset = null;
    @JsonProperty(value="endOffset")
    private @Nullable Integer endOffset = null;
    @JsonProperty(value="startLine")
    private @Nullable Integer startLine = null;
    @JsonProperty(value="endLine")
    private @Nullable Integer endLine = null;
    @JsonProperty(value="identifier")
    private @Nullable String identifier;
    @JsonProperty(value="findingProperties")
    private @Nullable Map<String, Object> findingProperties;

    public ExternalFindingData(String findingTypeId, String message, @Nullable ETrafficLightColor assessment, @Nullable Integer startLine, @Nullable Integer endLine) {
        this.findingTypeId = findingTypeId;
        this.message = message;
        this.assessment = assessment;
        this.startLine = startLine;
        this.endLine = endLine;
    }

    public ExternalFindingData() {
    }

    public String toString() {
        return "ExternalFindingData [findingTypeId=" + this.findingTypeId + ", message=" + this.message + ", assessment=" + String.valueOf(this.assessment) + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", startLine=" + this.startLine + ", endLine=" + this.endLine + "]";
    }

    public String getFindingTypeId() {
        return this.findingTypeId;
    }

    public String getMessage() {
        return this.message;
    }

    public ETrafficLightColor getAssessment() {
        if (this.assessment == null) {
            return ETrafficLightColor.YELLOW;
        }
        return this.assessment;
    }

    public Integer getStartOffset() {
        return this.startOffset;
    }

    public Integer getEndOffset() {
        return this.endOffset;
    }

    public Integer getStartLine() {
        return this.startLine;
    }

    public Integer getEndLine() {
        return this.endLine;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void validate() throws ReportParserException {
        if (StringUtils.isEmpty((String)this.findingTypeId)) {
            throw new ReportParserException("The finding's attribute findingTypeId may not be empty/null! (" + this.toString() + ")");
        }
        if (StringUtils.isEmpty((String)this.message)) {
            throw new ReportParserException("The finding's message may not be empty! (" + this.toString() + ")");
        }
        if (this.startOffset == null && this.endOffset != null || this.startOffset != null && this.endOffset == null) {
            throw new ReportParserException("When using finding offsets, both need to be non-null! (" + this.toString() + ")");
        }
    }

    public Map<String, Object> getProperties() {
        if (this.findingProperties == null) {
            return Collections.emptyMap();
        }
        return this.findingProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalFindingData that = (ExternalFindingData)o;
        return this.findingTypeId.equals(that.findingTypeId) && this.message.equals(that.message) && this.assessment == that.assessment && Objects.equals(this.startOffset, that.startOffset) && Objects.equals(this.endOffset, that.endOffset) && Objects.equals(this.startLine, that.startLine) && Objects.equals(this.endLine, that.endLine) && Objects.equals(this.identifier, that.identifier) && Objects.equals(this.findingProperties, that.findingProperties);
    }

    public int hashCode() {
        return Objects.hash(this.findingTypeId, this.message, this.assessment, this.startOffset, this.endOffset, this.startLine, this.endLine, this.identifier, this.findingProperties);
    }
}

