/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.index.repository.AcceptAllMergedRevisionsFilter;
import com.teamscale.index.repository.MergedRevisionsFilter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class MergeAncestorExplorer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MergedRevisionsFilter sourceMergedRevisionFilter;
    private final MergedRevisionsFilter targetMergedRevisionFilter;

    public MergeAncestorExplorer(MergedRevisionsFilter sourceMergedRevisionFilter, MergedRevisionsFilter targetMergedRevisionFilter) {
        this.sourceMergedRevisionFilter = sourceMergedRevisionFilter;
        this.targetMergedRevisionFilter = targetMergedRevisionFilter;
    }

    public Set<CommitDescriptor> exploreAncestorsOfSourceCommit(CommitDescriptor sourceCommit, Set<CommitDescriptor> stopCommits, Map<CommitDescriptor, ParentedCommitDescriptor> parentedCommits) throws RepositoryException {
        LOGGER.traceEntry("Exploring ancestors for source commit: {}", new Object[]{sourceCommit});
        return (Set)LOGGER.traceExit(MergeAncestorExplorer.exploreAncestors(sourceCommit, stopCommits, parentedCommits, this.sourceMergedRevisionFilter));
    }

    public Set<CommitDescriptor> exploreAncestorsOfTargetCommit(CommitDescriptor targetCommit, Set<CommitDescriptor> stopCommits, Map<CommitDescriptor, ParentedCommitDescriptor> parentedCommits) throws RepositoryException {
        LOGGER.traceEntry("Exploring ancestors for target commit: {}", new Object[]{targetCommit});
        return (Set)LOGGER.traceExit(MergeAncestorExplorer.exploreAncestors(targetCommit, stopCommits, parentedCommits, this.targetMergedRevisionFilter));
    }

    private static Set<CommitDescriptor> exploreAncestors(CommitDescriptor startCommit, Set<CommitDescriptor> stopCommits, Map<CommitDescriptor, ParentedCommitDescriptor> parentedCommits, MergedRevisionsFilter mergedRevisionsFilter) throws RepositoryException {
        HashSet<CommitDescriptor> ancestors = new HashSet<CommitDescriptor>();
        HashSet<CommitDescriptor> exploredCommits = new HashSet<CommitDescriptor>();
        ArrayDeque<CommitDescriptor> commitsToExplore = new ArrayDeque<CommitDescriptor>();
        commitsToExplore.add(startCommit);
        exploredCommits.add(startCommit);
        while (!commitsToExplore.isEmpty()) {
            CommitDescriptor currentCommit = (CommitDescriptor)commitsToExplore.poll();
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> ((CommitDescriptor)currentCommit).toString();
            supplierArray[1] = () -> String.join((CharSequence)",", ancestors.stream().map(CommitDescriptor::toString).toList());
            LOGGER.trace("Currently exploring commit '{}' with current ancestors set: {}", supplierArray);
            ParentedCommitDescriptor parentedNext = parentedCommits.get(currentCommit);
            LOGGER.trace("Currently exploring parented commit '{}'", (Object)parentedNext);
            if (parentedNext == null) continue;
            if (mergedRevisionsFilter.isContainedInMergeOrOnInitialBranch(parentedNext) && !ancestors.add(currentCommit)) {
                LOGGER.trace("Skipping commit as it was processed in another path.");
                continue;
            }
            if (stopCommits.contains(currentCommit)) {
                LOGGER.trace("Skipping commit as it's a stop commit.");
                continue;
            }
            List<CommitDescriptor> toBeExploredParentCommits = MergeAncestorExplorer.calculateToBeExploredParentCommits(parentedNext, exploredCommits);
            commitsToExplore.addAll(toBeExploredParentCommits);
            exploredCommits.addAll(toBeExploredParentCommits);
            LOGGER.trace("Commits currently in the commitsToExplore: {}", new Supplier[]{() -> String.join((CharSequence)",", commitsToExplore.stream().map(CommitDescriptor::toString).toList())});
        }
        return ancestors;
    }

    private static @NonNull List<CommitDescriptor> calculateToBeExploredParentCommits(ParentedCommitDescriptor parentedNext, Set<CommitDescriptor> exploredCommits) {
        List toBeExploredParentCommits = CollectionUtils.filter((Collection)parentedNext.getParentCommits(), commit -> !exploredCommits.contains(commit));
        if (toBeExploredParentCommits.size() < parentedNext.getParentCommits().size()) {
            LOGGER.trace("Potential cycle avoided! Filtered out parent commits from [{}] that were already explored.", (Object)parentedNext.toStringWithParents());
        }
        return toBeExploredParentCommits;
    }

    public static MergeAncestorExplorer getMergeAncestorExplorerWithAcceptAllFilters() {
        return new MergeAncestorExplorer(new AcceptAllMergedRevisionsFilter(null), new AcceptAllMergedRevisionsFilter(null));
    }
}

