/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.filesystem.multiversion;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.PairList;

public class MultiVersionFileSystemCommit
implements Comparable<MultiVersionFileSystemCommit> {
    private static final Pattern SINGLE_REVISION_PATTERN = Pattern.compile("(?:([-a-zA-Z0-9#]+)[_:.])?(\\d+)");
    private static final Pattern REVISION_DIRECTORY_PATTERN = Pattern.compile(SINGLE_REVISION_PATTERN.toString() + "(_" + String.valueOf(SINGLE_REVISION_PATTERN) + ")*");
    private final String directoryName;
    private final String branchName;
    private final long timestamp;
    private final String customCommitMessage;
    private final PairList<String, Long> additionalParentCommits = new PairList();

    public MultiVersionFileSystemCommit(String directoryName, String defaultBranchName) throws RepositoryException {
        this(directoryName, defaultBranchName, null);
    }

    public MultiVersionFileSystemCommit(String directoryName, String defaultBranchName, String customCommitMessage) throws RepositoryException {
        this.directoryName = directoryName;
        this.customCommitMessage = customCommitMessage;
        if (!REVISION_DIRECTORY_PATTERN.matcher(directoryName).matches()) {
            throw new RepositoryException("Invalid revision directory: " + directoryName + "! Must match " + REVISION_DIRECTORY_PATTERN.pattern());
        }
        Matcher matcher = SINGLE_REVISION_PATTERN.matcher(directoryName);
        matcher.find();
        this.branchName = MultiVersionFileSystemCommit.extractBranchName(matcher, defaultBranchName);
        this.timestamp = MultiVersionFileSystemCommit.extractTimestamp(matcher);
        while (matcher.find()) {
            this.additionalParentCommits.add((Object)MultiVersionFileSystemCommit.extractBranchName(matcher, defaultBranchName), (Object)MultiVersionFileSystemCommit.extractTimestamp(matcher));
        }
    }

    private static String extractBranchName(Matcher matcher, String defaultBranchName) {
        String branchPart = matcher.group(1);
        if (branchPart == null) {
            return defaultBranchName;
        }
        return branchPart;
    }

    private static Long extractTimestamp(Matcher matcher) {
        return Long.parseLong(matcher.group(2));
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public PairList<String, Long> getAdditionalParentCommits() {
        return this.additionalParentCommits;
    }

    @Override
    public int compareTo(MultiVersionFileSystemCommit other) {
        return Long.compare(this.getTimestamp(), other.getTimestamp());
    }

    public String getCommitMessage() {
        Object commitMessage = this.getRevision();
        if (this.customCommitMessage != null) {
            commitMessage = (String)commitMessage + " " + this.customCommitMessage;
        }
        return commitMessage;
    }

    public String getRevision() {
        return this.branchName + ":" + this.timestamp;
    }

    public String toString() {
        return this.getCommitMessage() + String.valueOf(this.additionalParentCommits);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MultiVersionFileSystemCommit)) {
            return false;
        }
        MultiVersionFileSystemCommit other = (MultiVersionFileSystemCommit)obj;
        return this.branchName.equals(other.branchName) && this.timestamp == other.timestamp;
    }

    public int hashCode() {
        return Objects.hash(this.branchName, this.timestamp);
    }

    public CommitDescriptor toCommitDescriptor() {
        return new CommitDescriptor(this.branchName, this.timestamp);
    }
}

