/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.cloud;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.index.repository.git.bitbucket.cloud.BitbucketCloudInstallationIndex;
import com.teamscale.index.repository.git.bitbucket.cloud.client.BitbucketCloudClient;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudRepository;
import com.teamscale.index.repository.git.bitbucket.cloud.client.model.BitbucketCloudWorkspace;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class CachingRepositoryFullNameProvider {
    private static final String ALL_REPOSITORIES_KEY = "all-repositories";
    private static final Duration CACHE_RETENTION_TIME = Duration.ofMinutes(15L);
    private static final Logger LOGGER = LogManager.getLogger();
    private static LoadingCache<String, Map<BitbucketCloudWorkspace, List<BitbucketCloudRepository>>> repositoriesCache;

    public static String getRepositoryUuidFullName(String fullName, GlobalStorageSystem globalStorageSystem) throws ProjectConfigurationException, ServiceCallException {
        CachingRepositoryFullNameProvider.ensureCacheCreated(globalStorageSystem);
        return CachingRepositoryFullNameProvider.getRepositoryUuidFullName(fullName, CachingRepositoryFullNameProvider.getWorkspaceToRepositoriesMap());
    }

    private static synchronized void ensureCacheCreated(GlobalStorageSystem globalStorageSystem) {
        if (repositoriesCache != null) {
            return;
        }
        repositoriesCache = CacheBuilder.newBuilder().expireAfterWrite(CACHE_RETENTION_TIME).build((CacheLoader)new RepositoryCacheLoader(globalStorageSystem));
    }

    private static Map<BitbucketCloudWorkspace, List<BitbucketCloudRepository>> computeWorkspaceToRepositoriesMap(List<BitbucketCloudRepository> repositories) {
        HashMap<BitbucketCloudWorkspace, List<BitbucketCloudRepository>> workspaceToRepositoriesMap = new HashMap<BitbucketCloudWorkspace, List<BitbucketCloudRepository>>();
        repositories.forEach(repo -> workspaceToRepositoriesMap.computeIfAbsent(repo.getWorkspace(), key -> new ArrayList()).add(repo));
        LOGGER.debug("Map of workspaces to repositories: " + String.valueOf(workspaceToRepositoriesMap));
        return workspaceToRepositoriesMap;
    }

    private static Map<BitbucketCloudWorkspace, List<BitbucketCloudRepository>> getWorkspaceToRepositoriesMap() throws ProjectConfigurationException {
        try {
            return (Map)repositoriesCache.get((Object)ALL_REPOSITORIES_KEY);
        }
        catch (ExecutionException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
    }

    private static List<BitbucketCloudRepository> loadRepositoriesFromServer(GlobalStorageSystem globalStorageSystem) throws ServiceCallException {
        try {
            BitbucketCloudInstallationIndex installationIndex = (BitbucketCloudInstallationIndex)globalStorageSystem.openGlobalIndex(BitbucketCloudInstallationIndex.class);
            List<BitbucketCloudInstallationIndex.BitbucketInstallation> installations = installationIndex.getAllInstallations();
            ArrayList<BitbucketCloudRepository> result = new ArrayList<BitbucketCloudRepository>();
            for (BitbucketCloudInstallationIndex.BitbucketInstallation installation : installations) {
                BitbucketCloudClient client = new BitbucketCloudClient(installation, (AccessTokenIndex)globalStorageSystem.openGlobalIndex(AccessTokenIndex.class), LOGGER);
                List<BitbucketCloudRepository> repositoriesInWorkspace = client.getRepositoriesInWorkspace(installation.getInstallationUsername());
                LOGGER.debug("Repositories for workspace '" + installation.getInstallationUsername() + "': " + String.valueOf(repositoriesInWorkspace));
                result.addAll(repositoriesInWorkspace);
            }
            return result;
        }
        catch (JsonSerializationException | StorageException e) {
            throw new ServiceCallException(e);
        }
    }

    private static String getRepositoryUuidFullName(String fullName, Map<BitbucketCloudWorkspace, List<BitbucketCloudRepository>> workspaceToRepositoriesMap) throws ProjectConfigurationException {
        String[] parts = fullName.split("/", 2);
        if (parts.length != 2) {
            throw new ProjectConfigurationException("Expected %s (%s) to contain a '/'".formatted("Repository name", fullName));
        }
        LOGGER.debug("Resolving UUIDs for " + fullName + ". Using " + parts[0] + " for workspace and " + parts[1] + " for repository. Lookup in " + String.valueOf(workspaceToRepositoriesMap));
        for (BitbucketCloudWorkspace workspace : workspaceToRepositoriesMap.keySet()) {
            if (!workspace.getSlug().equals(parts[0]) && !workspace.getUuid().equals(parts[0])) continue;
            return workspace.getUuid() + "/" + CachingRepositoryFullNameProvider.getRepositoryUuidFromSlug(workspaceToRepositoriesMap.get(workspace), parts[1]);
        }
        throw new ProjectConfigurationException("Could not resolve UUIDs of Bitbucket cloud repository or workspace: " + fullName);
    }

    private static String getRepositoryUuidFromSlug(List<BitbucketCloudRepository> repositories, String repositorySlug) throws ProjectConfigurationException {
        for (BitbucketCloudRepository repository : repositories) {
            if (!repository.getUuid().equals(repositorySlug) && (repository.getSlug() == null || !repository.getSlug().equals(repositorySlug))) continue;
            return repository.getUuid();
        }
        throw new ProjectConfigurationException("Could not resolve UUID of Bitbucket cloud repository: " + repositorySlug);
    }

    private static class RepositoryCacheLoader
    extends CacheLoader<String, Map<BitbucketCloudWorkspace, List<BitbucketCloudRepository>>> {
        private final GlobalStorageSystem globalStorageSystem;

        private RepositoryCacheLoader(GlobalStorageSystem globalStorageSystem) {
            this.globalStorageSystem = globalStorageSystem;
        }

        public @NonNull Map<BitbucketCloudWorkspace, List<BitbucketCloudRepository>> load(@NonNull String ignored) throws ServiceCallException {
            List<BitbucketCloudRepository> repositories = CachingRepositoryFullNameProvider.loadRepositoriesFromServer(this.globalStorageSystem);
            return CachingRepositoryFullNameProvider.computeWorkspaceToRepositoriesMap(repositories);
        }
    }
}

