/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import com.google.common.base.Preconditions;
import com.teamscale.index.external.ExternalAnalysisPartitionIndex;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.merge_request.MergeRequestAnnotationInput;
import com.teamscale.index.repository.git.common.CcpIntegrationFeatureEnablements;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.ExternalUploadsVotingCondition;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.testcoverage.LineCoverageIndex;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.function.BiPredicateWithException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.jetbrains.annotations.VisibleForTesting;

public class TestingIntegrationRequirementsChecker {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SupplierWithException<ExternalResultsPartitionLastUpdateIndex, StorageException> externalResultsPartitionLastUpdateIndex;
    private final SupplierWithException<LineCoverageIndex, StorageException> lineCoverageIndex;
    private final SupplierWithException<IBranchingLayer, StorageException> tokenElementBranchingLayer;
    private final ExternalUploadsVotingCondition externalUploadsVotingCondition;
    private final SupplierWithException<ExternalAnalysisPartitionIndex, StorageException> externalAnalysisPartitionIndex;

    public TestingIntegrationRequirementsChecker(ProjectStorageSystem projectStorage, CommitDescriptor schedulingCommit, @Nullable ExternalUploadsVotingCondition externalUploadsVotingCondition) {
        this.externalUploadsVotingCondition = externalUploadsVotingCondition;
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readHead((String)schedulingCommit.getBranchName());
        this.externalResultsPartitionLastUpdateIndex = SupplierWithException.memoize(() -> (ExternalResultsPartitionLastUpdateIndex)projectStorage.openProjectIndex(ExternalResultsPartitionLastUpdateIndex.class, historyAccessOption));
        this.lineCoverageIndex = SupplierWithException.memoize(() -> (LineCoverageIndex)projectStorage.openProjectIndex(LineCoverageIndex.class, historyAccessOption));
        this.tokenElementBranchingLayer = SupplierWithException.memoize(() -> projectStorage.openBranchingLayer("content", TokenElementIndex.class));
        this.externalAnalysisPartitionIndex = SupplierWithException.memoize(() -> (ExternalAnalysisPartitionIndex)projectStorage.openProjectIndex(ExternalAnalysisPartitionIndex.class, null));
    }

    public ETestingIntegrationRequirementsCheckerResult checkLineCommentsRequirements(CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequestAnnotationInput input) throws StorageException {
        return TestingIntegrationRequirementsChecker.checkRequirements(schedulingParameters, input, this.getTestGapLineCommentsRequirements(), "Skipping adding test gap line comments");
    }

    public ETestingIntegrationRequirementsCheckerResult checkTestGapVotingRequirements(CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequestAnnotationInput input) throws StorageException {
        return TestingIntegrationRequirementsChecker.checkRequirements(schedulingParameters, input, this.getTestGapVotingRequirements(), "Skipping voting on test gaps");
    }

    public ETestingIntegrationRequirementsCheckerResult checkTestCoverageVotingRequirements(CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequestAnnotationInput input) throws StorageException {
        return TestingIntegrationRequirementsChecker.checkRequirements(schedulingParameters, input, this.getTestCoverageVotingRequirements(), "Skipping voting on test coverage");
    }

    @VisibleForTesting
    ETestingIntegrationRequirementsCheckerResult checkCommonRequirements(CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequestAnnotationInput input) throws StorageException {
        return TestingIntegrationRequirementsChecker.checkRequirements(schedulingParameters, input, this.getCommonRequirements(), "Missing external data");
    }

    private static ETestingIntegrationRequirementsCheckerResult checkRequirements(CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequestAnnotationInput input, Stream<TestingIntegrationRequirement> requirementsToCheckStream, String messageStart) throws StorageException {
        Iterable requirementsToCheck = requirementsToCheckStream::iterator;
        for (TestingIntegrationRequirement requirement : requirementsToCheck) {
            if (requirement.checkerFunction().test((Object)schedulingParameters, (Object)input)) continue;
            ETestingIntegrationRequirementsCheckerResult failedCheckResult = requirement.resultIfNotFulfilled();
            LOGGER.info(LoggingUtils.INTERACTION, "{} for commit {}: {}", (Object)messageStart, (Object)schedulingParameters.schedulingCommit(), (Object)failedCheckResult.getFailureReason());
            return failedCheckResult;
        }
        return ETestingIntegrationRequirementsCheckerResult.SUCCESS;
    }

    protected Stream<TestingIntegrationRequirement> getCommonRequirements() {
        return Stream.of(new TestingIntegrationRequirement((BiPredicateWithException<CommitVotingTriggerBase.SchedulingParameters, MergeRequestAnnotationInput, StorageException>)((BiPredicateWithException)(param, in) -> !in.isBuildIncomplete()), ETestingIntegrationRequirementsCheckerResult.BUILD_INCOMPLETE), new TestingIntegrationRequirement((BiPredicateWithException<CommitVotingTriggerBase.SchedulingParameters, MergeRequestAnnotationInput, StorageException>)((BiPredicateWithException)(param, in) -> this.projectHasTestCoveragePartitions()), ETestingIntegrationRequirementsCheckerResult.NO_TEST_COVERAGE), new TestingIntegrationRequirement((BiPredicateWithException<CommitVotingTriggerBase.SchedulingParameters, MergeRequestAnnotationInput, StorageException>)((BiPredicateWithException)(param, in) -> this.coveragePartitionHasBeenUpdated(param.schedulingCommit())), ETestingIntegrationRequirementsCheckerResult.OUTDATED_TEST_COVERAGE), new TestingIntegrationRequirement((BiPredicateWithException<CommitVotingTriggerBase.SchedulingParameters, MergeRequestAnnotationInput, StorageException>)((BiPredicateWithException)(param, in) -> !this.waitingForExternalUploads((CommitVotingTriggerBase.SchedulingParameters)param)), ETestingIntegrationRequirementsCheckerResult.WAITING_EXTERNAL_UPLOADS));
    }

    private Stream<TestingIntegrationRequirement> getTestGapRequirements() {
        return Stream.concat(this.getCommonRequirements(), Stream.of(new TestingIntegrationRequirement((BiPredicateWithException<CommitVotingTriggerBase.SchedulingParameters, MergeRequestAnnotationInput, StorageException>)((BiPredicateWithException)(param, in) -> in.testGapInfo != null), ETestingIntegrationRequirementsCheckerResult.ERROR_CALCULATING_TGA_DATA)));
    }

    private Stream<TestingIntegrationRequirement> getTestGapLineCommentsRequirements() {
        return Stream.concat(Stream.of(new TestingIntegrationRequirement((BiPredicateWithException<CommitVotingTriggerBase.SchedulingParameters, MergeRequestAnnotationInput, StorageException>)((BiPredicateWithException)(param, in) -> CcpIntegrationFeatureEnablements.isTestGapIntegrationEnabled(param.connector())), ETestingIntegrationRequirementsCheckerResult.TEST_GAP_INTEGRATION_DISABLED)), Stream.concat(this.getTestGapRequirements(), Stream.of(new TestingIntegrationRequirement((BiPredicateWithException<CommitVotingTriggerBase.SchedulingParameters, MergeRequestAnnotationInput, StorageException>)((BiPredicateWithException)(param, in) -> CcpIntegrationFeatureEnablements.isAnyTestGapCommentOptionEnabled(param.connector())), ETestingIntegrationRequirementsCheckerResult.TEST_GAP_LINE_COMMENT_OPTIONS_DISABLED))));
    }

    private Stream<TestingIntegrationRequirement> getTestGapVotingRequirements() {
        return Stream.concat(Stream.of(new TestingIntegrationRequirement((BiPredicateWithException<CommitVotingTriggerBase.SchedulingParameters, MergeRequestAnnotationInput, StorageException>)((BiPredicateWithException)(param, in) -> CcpIntegrationFeatureEnablements.isTestGapIntegrationEnabled(param.connector())), ETestingIntegrationRequirementsCheckerResult.TEST_GAP_INTEGRATION_DISABLED), new TestingIntegrationRequirement((BiPredicateWithException<CommitVotingTriggerBase.SchedulingParameters, MergeRequestAnnotationInput, StorageException>)((BiPredicateWithException)(param, in) -> !CcpIntegrationFeatureEnablements.isAnyTestGapCommentOptionEnabled(param.connector()) || !in.isBuildIncomplete() || in.testGapInfo == null || in.testGapInfo.allChangedMethods().isEmpty()), ETestingIntegrationRequirementsCheckerResult.BUILD_INCOMPLETE), new TestingIntegrationRequirement((BiPredicateWithException<CommitVotingTriggerBase.SchedulingParameters, MergeRequestAnnotationInput, StorageException>)((BiPredicateWithException)(param, in) -> CcpIntegrationFeatureEnablements.isVotingForTestGapsEnabled(param.connector())), ETestingIntegrationRequirementsCheckerResult.TEST_GAP_VOTING_DISABLED)), this.getTestGapRequirements());
    }

    private Stream<TestingIntegrationRequirement> getTestCoverageVotingRequirements() {
        return Stream.concat(Stream.of(new TestingIntegrationRequirement((BiPredicateWithException<CommitVotingTriggerBase.SchedulingParameters, MergeRequestAnnotationInput, StorageException>)((BiPredicateWithException)(param, in) -> CcpIntegrationFeatureEnablements.isVotingForTestCoverageEnabled(param.connector())), ETestingIntegrationRequirementsCheckerResult.TEST_COVERAGE_VOTING_DISABLED)), this.getCommonRequirements());
    }

    @VisibleForTesting
    public boolean waitingForExternalUploads(CommitVotingTriggerBase.SchedulingParameters schedulingParameters) throws StorageException {
        return this.externalUploadsVotingCondition != null && !this.externalUploadsVotingCondition.isFulfilledFor(schedulingParameters.connector());
    }

    @VisibleForTesting
    public boolean projectHasTestCoveragePartitions() throws StorageException {
        return !((ExternalAnalysisPartitionIndex)this.externalAnalysisPartitionIndex.get()).getCoveragePartitions().isEmpty();
    }

    @VisibleForTesting
    public boolean coveragePartitionHasBeenUpdated(CommitDescriptor commit) throws StorageException {
        Optional<Long> latestCodeTimestamp = Optional.ofNullable(((IBranchingLayer)this.tokenElementBranchingLayer.get()).getNewestCommitBeforeOrAt(commit.getBranchName(), commit.getTimestamp())).map(IBranchCommitInfo::getTimestamp);
        if (latestCodeTimestamp.isEmpty()) {
            return false;
        }
        List testCoveragePartitions = ((LineCoverageIndex)((Object)this.lineCoverageIndex.get())).getPartitions();
        if (testCoveragePartitions.isEmpty()) {
            return false;
        }
        List<@Nullable CommitDescriptor> testCoveragePartitionsLastUpdate = ((ExternalResultsPartitionLastUpdateIndex)this.externalResultsPartitionLastUpdateIndex.get()).getLastUpdatedCommits(testCoveragePartitions);
        for (CommitDescriptor lastUpdate : testCoveragePartitionsLastUpdate) {
            if (lastUpdate == null || lastUpdate.getTimestamp() < latestCodeTimestamp.get()) continue;
            return true;
        }
        return false;
    }

    public static enum ETestingIntegrationRequirementsCheckerResult {
        BUILD_INCOMPLETE(false, "Teamscale is waiting for the pull request's build pipeline.", "Waiting for build pipeline"),
        NO_TEST_COVERAGE(false, "Test coverage information is not available for this project.", "No test coverage available"),
        ERROR_CALCULATING_TGA_DATA(false, "Test coverage information could not be calculated due to an error.", "Error during test gap calculation"),
        OUTDATED_TEST_COVERAGE(false, "Test coverage partitions have not been updated for the latest commit in this pull request.", "No test coverage for the latest commit available"),
        WAITING_EXTERNAL_UPLOADS(false, "There are required external upload partitions that have not been updated yet.", "Waiting for external uploads"),
        TEST_GAP_INTEGRATION_DISABLED(false, "Test gap integration is disabled.", "Test gap integration disabled"),
        TEST_GAP_LINE_COMMENT_OPTIONS_DISABLED(false, "Posting of test gap line comments is not enabled.", "Test gap comments disabled"),
        TEST_GAP_VOTING_DISABLED(false, "Voting for test gaps is disabled.", "Test gap voting disabled"),
        TEST_COVERAGE_VOTING_DISABLED(false, "Voting for test coverage is disabled.", "Test coverage voting disabled"),
        SUCCESS(true, "", "");

        private final String failureReason;
        private final String shortFailureReason;
        private final boolean requirementsFulfilled;

        private ETestingIntegrationRequirementsCheckerResult(boolean requirementsFulfilled, String failureReason, String shortFailureReason) {
            if (!requirementsFulfilled) {
                Preconditions.checkArgument((failureReason != null && !failureReason.isEmpty() ? 1 : 0) != 0, (Object)"Parameter %s should not be null or empty if %s is false.".formatted("failureReason", "requirementsFulfilled"));
                Preconditions.checkArgument((shortFailureReason != null && !shortFailureReason.isEmpty() ? 1 : 0) != 0, (Object)"Parameter %s should not be null or empty if %s is false.".formatted("shortFailureReason", "requirementsFulfilled"));
            }
            this.requirementsFulfilled = requirementsFulfilled;
            this.failureReason = failureReason;
            this.shortFailureReason = shortFailureReason;
        }

        public String getFailureReason() {
            return this.failureReason;
        }

        public String getShortFailureReason() {
            return this.shortFailureReason;
        }

        public boolean isRequirementsFulfilled() {
            return this.requirementsFulfilled;
        }
    }

    protected record TestingIntegrationRequirement(BiPredicateWithException<CommitVotingTriggerBase.SchedulingParameters, MergeRequestAnnotationInput, StorageException> checkerFunction, ETestingIntegrationRequirementsCheckerResult resultIfNotFulfilled) {
    }
}

