/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.teamscale.index.repository.git.gerrit.GerritUtils;
import java.util.Comparator;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GerritPatchSetInfo
implements Comparable<GerritPatchSetInfo> {
    protected final long changeNumber;
    protected final long patchSetNumber;

    public GerritPatchSetInfo(long changeNumber, long patchSetNumber) {
        this.changeNumber = changeNumber;
        this.patchSetNumber = patchSetNumber;
    }

    public String getBranchName() {
        return GerritUtils.getGerritBranchName(this.changeNumber, this.patchSetNumber);
    }

    public String getChangeBranchNamePrefix() {
        return GerritUtils.getGerritBranchNamePrefix(this.changeNumber);
    }

    public long getChangeNumber() {
        return this.changeNumber;
    }

    public long getPatchSetNumber() {
        return this.patchSetNumber;
    }

    public String toString() {
        return "GerritPatchSetInfo{changeNumber=" + this.changeNumber + ", patchSetNumber=" + this.patchSetNumber + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GerritPatchSetInfo that = (GerritPatchSetInfo)o;
        return this.changeNumber == that.changeNumber && this.patchSetNumber == that.patchSetNumber;
    }

    public int hashCode() {
        return Objects.hash(this.changeNumber, this.patchSetNumber);
    }

    @Override
    public int compareTo(@NonNull GerritPatchSetInfo o) {
        return Comparator.comparing(GerritPatchSetInfo::getChangeNumber).thenComparing(GerritPatchSetInfo::getPatchSetNumber).compare(this, o);
    }
}

