/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.GitHubRepositoryConnectorUrl;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.metric.MetricBadgesConfiguration;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.client.GitHubAppClient;
import com.teamscale.core.authenticate.github.dto.InstallationRepository;
import com.teamscale.index.repository.git.common.AppBasedGitRepositoryConnectorDescriptorBase;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.GitRepositoryManagementConnectorDescriptorBase;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.AppBasedGithubConnectorValidationUtils;
import com.teamscale.index.repository.git.github.GitHubAppBasedRepositoryAccessHelper;
import com.teamscale.index.repository.git.github.GitHubChangeRetriever;
import com.teamscale.index.repository.git.github.GitHubContentUpdater;
import com.teamscale.index.repository.git.github.GitHubMergeRequestAnnotationTrigger;
import com.teamscale.index.repository.git.github.GitHubMergeRequestSynchronizer;
import com.teamscale.index.repository.git.github.index.GitHubCheckRunIndex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.string.StringUtils;

@ConnectorDescriptor
public class GitHubRepositoryConnectorDescriptor
extends AppBasedGitRepositoryConnectorDescriptorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String ACCOUNT_IDENTIFIER = "unused-dummy";
    public static final String CONTEXT_IDENTIFIER_OPTION_NAME = "Context identifier";
    public static final String CONTEXT_IDENTIFIER_DEFAULT = "Teamscale";
    public static final String DEFAULT_GITHUB_URL = "https://github.com/";
    public static final String GITHUB_SERVER_URL_FIELD_NAME = "gitHubServerUrl";
    @ConfigExposed(name="GitHub Server URL", description="The URL the GitHub instance is reachable at.")
    private GitHubRepositoryConnectorUrl gitHubServerUrl;
    @ConfigExposed(name="Context identifier", description="Optional context identifier used for uploading the status to GitHub. The status always begins with 'Teamscale', but an additional identifier can be set here if multiple projects should vote for the same GitHub repository. The resulting status will be displayed as 'Teamscale (_context identifier_)'", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private String contextIdentifier;
    @ConfigExposed(name="Badges for Metrics", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="Metrics which should be tracked in merge requests via badges.")
    protected MetricBadgesConfiguration metricThresholdBadges = new MetricBadgesConfiguration();
    @ConfigExposed(name="Badges for Metric Groups", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false, description="Metrics which should be included in a summarized badge for their group in merge requests.")
    protected MetricBadgesConfiguration metricThresholdGroupBadges = new MetricBadgesConfiguration();
    private final SupplierWithException<ExternalCredentials, ConnectorValidationException> resolvedExternalCredentials = SupplierWithException.memoize(this::doResolveExternalCredentials);
    public static final String GITHUB_SERVER_URL_PARAMETER = "github-url";
    public static final String CONTEXT_IDENTIFIER_PARAMETER = "context-identifier";

    public GitHubRepositoryConnectorDescriptor() {
        super(ERepositoryConnector.GITHUB);
        this.autoExpose();
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(GitHubCheckRunIndex.class);
    }

    @Override
    protected String getCommitLinkTemplate() throws ConnectorValidationException {
        return GitHubRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(this.gitHubServerUrl.url(), this.repositoryName, "commit/{commitId}");
    }

    @Override
    protected String getCommitInMergeRequestLinkTemplate() {
        return GitHubRepositoryConnectorDescriptor.concatenateNonEmptyWithSlash(this.gitHubServerUrl.url(), this.repositoryName, "pull/{mergeRequestId}/commits/{commitId}");
    }

    public String getContextIdentifier() {
        return GitHubRepositoryConnectorDescriptor.computeContextIdentifier(this.contextIdentifier);
    }

    @Override
    public String getAccountIdentifier() {
        return ACCOUNT_IDENTIFIER;
    }

    @Override
    protected ExternalCredentials resolveExternalCredentials() throws ConnectorValidationException {
        return (ExternalCredentials)this.resolvedExternalCredentials.get();
    }

    private ExternalCredentials doResolveExternalCredentials() throws ConnectorValidationException {
        PlatformRepositoryIdentifier repositoryId = PlatformRepositoryIdentifier.fromRepositoryName(this.repositoryName, ConnectorValidationException::new);
        try {
            GitHubAppBasedRepositoryAccessHelper<ConnectorValidationException> repositoryAccessHelper = new GitHubAppBasedRepositoryAccessHelper<ConnectorValidationException>(this.gitHubServerUrl.url(), this.repositoryName, this.getContext().getGlobalStorageSystem(), ConnectorValidationException::new, LOGGER);
            long installationId = repositoryAccessHelper.getInstallationId();
            GitHubApplicationDescription applicationDescription = repositoryAccessHelper.getApplicationDescription();
            GitHubAppClient client = repositoryAccessHelper.getAppClient();
            return this.prepareRepositoryInfoAndValidateUser(applicationDescription, client, repositoryId, installationId);
        }
        catch (ServiceCallException | ProjectConfigurationException | StorageException e) {
            throw new ConnectorValidationException(e);
        }
    }

    private ExternalCredentials prepareRepositoryInfoAndValidateUser(GitHubApplicationDescription applicationDescription, GitHubAppClient client, PlatformRepositoryIdentifier repositoryId, Long installationId) throws ConnectorValidationException, ServiceCallException, StorageException {
        InstallationRepository repository = (InstallationRepository)client.getInstallationRepositories(installationId.longValue()).getRepositoryByFullName(this.repositoryName).orElseThrow(() -> new ConnectorValidationException("Repository " + String.valueOf(repositoryId) + " not found. This either does not exist or the installation is not allowed to access the repository."));
        ExternalCredentials credentials = new ExternalCredentials(ACCOUNT_IDENTIFIER, repository.getCloneUrl(), "x-access-token", client.getOrCreateInstallationToken(installationId.longValue()));
        AppBasedGithubConnectorValidationUtils.checkUserIsCollaborator(applicationDescription, credentials.password, repositoryId, this.getContext(), LOGGER);
        AppBasedGithubConnectorValidationUtils.checkServerVersion(applicationDescription, credentials.password, GitRepositoryManagementConnectorDescriptorBase::isOutdatedServerVersion, LOGGER);
        return credentials;
    }

    public GitHubRepositoryConnectorUrl getGitHubServerUrl() {
        return this.gitHubServerUrl;
    }

    public void setGitHubServerUrl(GitHubRepositoryConnectorUrl gitHubServerUrl) {
        this.gitHubServerUrl = gitHubServerUrl;
    }

    @Override
    protected String getOverlapCriteria() throws ConnectorValidationException {
        return super.getOverlapCriteria() + "\ncontextIdentifier: " + this.contextIdentifier;
    }

    @Override
    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.setCommonParameters(triggerBuilder, triggerCreator);
        triggerBuilder.setTriggerParameter("repository-path", this.getRepositoryUri().toString());
        triggerBuilder.setTriggerParameter(GITHUB_SERVER_URL_PARAMETER, this.gitHubServerUrl.url());
    }

    @Override
    protected void setPullRequestSynchronizerParameters(TriggerBuilder trigger) throws ProjectConfigurationException {
        trigger.setTriggerParameter(GITHUB_SERVER_URL_PARAMETER, this.gitHubServerUrl.url());
        trigger.setTriggerParameter(CONTEXT_IDENTIFIER_PARAMETER, GitHubRepositoryConnectorDescriptor.computeContextIdentifier(this.contextIdentifier));
        super.setPullRequestSynchronizerParameters(trigger);
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return GitHubContentUpdater.class;
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return GitHubChangeRetriever.class;
    }

    @Override
    public Class<? extends AnalysisStepBase> getPullRequestSynchronizerClass() {
        return GitHubMergeRequestSynchronizer.class;
    }

    @Override
    public Class<? extends CommitVotingTriggerBase<?>> getMergeRequestAnnotationTriggerClass() {
        return GitHubMergeRequestAnnotationTrigger.class;
    }

    @Override
    protected boolean requiresBuildCompleteness() {
        return true;
    }

    @Override
    protected boolean supportsTestRelatedVoting() {
        return true;
    }

    public static String computeContextIdentifier(String contextIdentifier) {
        if (StringUtils.isEmpty((String)contextIdentifier)) {
            return CONTEXT_IDENTIFIER_DEFAULT;
        }
        return "%s (%s)".formatted(CONTEXT_IDENTIFIER_DEFAULT, contextIdentifier);
    }
}

