/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gitlab.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.git.gitlab.data.GitLabNote;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.VisibleForTesting;

public class GitLabDiscussion {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="notes")
    private List<GitLabNote> notes;

    public GitLabDiscussion() {
    }

    @VisibleForTesting
    public GitLabDiscussion(GitLabNote note) {
        this.notes = Collections.singletonList(note);
    }

    public String getId() {
        return this.id;
    }

    public List<GitLabNote> getNotes() {
        return this.notes;
    }

    public long getFirstNoteId() {
        if (this.notes.isEmpty()) {
            return 0L;
        }
        return this.getFirstNote().getId();
    }

    public String getFirstNoteBody() {
        if (this.notes.isEmpty()) {
            return "";
        }
        return this.getFirstNote().getBody();
    }

    public GitLabNote getFirstNote() {
        return this.notes.getFirst();
    }

    public LocalDateTime getFirstNoteUpdatedAt() {
        if (this.notes.isEmpty()) {
            return LocalDateTime.MIN;
        }
        return this.getFirstNote().getUpdatedAt();
    }

    public Optional<String> getNewPath() {
        if (this.notes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.getFirstNote().getPosition().getNewPath());
    }

    public String toString() {
        return "GitLabDiscussion{id='" + this.id + "', notes=" + String.valueOf(this.notes) + "}";
    }

    public boolean isResolved() {
        for (GitLabNote note : this.notes) {
            if (!note.isResolved()) continue;
            return true;
        }
        return false;
    }
}

