/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.scm_manager;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.index.merge_request.MergeRequestSynchronizerBase;
import com.teamscale.index.repository.RepositoryChangeRetrieverBase;
import com.teamscale.index.repository.git.scm_manager.ScmManagerChangeRetriever;
import com.teamscale.index.repository.git.scm_manager.ScmManagerClient;
import com.teamscale.index.repository.git.scm_manager.ScmManagerMergeRequestProvider;
import com.teamscale.index.repository.git.scm_manager.data.ScmManagerPullRequests;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

@AnalysisStep
public class ScmManagerMergeRequestSynchronizer
extends MergeRequestSynchronizerBase<ScmManagerMergeRequestProvider, ScmManagerPullRequests.PullRequest> {
    private static final Logger LOGGER = LogManager.getLogger();
    @StepParameter(value="repository-name")
    private String repositoryName;
    @StepParameter(value="account-identifier")
    private String accountIdentifier;

    @Override
    protected ScmManagerMergeRequestProvider createMergeRequestProvider() throws StorageException {
        ExternalCredentials credentials = this.getExternalCredentials(this.accountIdentifier);
        ScmManagerClient client = new ScmManagerClient(credentials, LOGGER);
        return new ScmManagerMergeRequestProvider(this.repositoryName, client);
    }

    @Override
    protected String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    protected Class<? extends RepositoryChangeRetrieverBase> getChangeRetrieverClass() {
        return ScmManagerChangeRetriever.class;
    }
}

