/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.git.GitPreviewUtils;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.TeamscaleGitCredentialsProvider;
import com.teamscale.index.repository.retrievers.IFilesRetriever;
import com.teamscale.index.repository.sap.abapsystem.AbapGitRepositoryConnection;
import com.teamscale.index.repository.sap.abapsystem.AbapRepositoryConnector;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.RepositoryException;

public class AbapFilesRetriever
implements IFilesRetriever {
    private final ServerOptionIndex serverOptionIndex;
    private final ConnectorConfiguration connectorConfiguration;

    public AbapFilesRetriever(ServerOptionIndex serverOptionIndex, ConnectorConfiguration connectorConfiguration) {
        this.serverOptionIndex = serverOptionIndex;
        this.connectorConfiguration = connectorConfiguration;
    }

    @Override
    public @NonNull Collection<@NonNull String> fetchFiles() throws RepositoryException, ProjectConfigurationException {
        String sapConnectionIdentifier = this.connectorConfiguration.getOptionValue("SAP connection");
        URI location = AbapRepositoryConnector.getRepositoryUri(sapConnectionIdentifier, this.serverOptionIndex);
        if (!new File(location).exists()) {
            throw new RepositoryException("There is no git repository at the expected location " + String.valueOf(location) + ". If you are updating the Teamscale Server, you need to copy/link the sap.abap.system directory from the previous Teamscale to keep those commits. If you set up a new instance, the next invocation of the SAP synchronization should create the git repository and make this error disappear.");
        }
        TeamscaleGitCredentialsProvider emptyCredentialsProvider = GitUtils.createEmptyCredentialsProvider();
        this.connectorConfiguration.setOptionValue("Default branch name", "master");
        List<String> allFiles = GitPreviewUtils.retrieveFilesFromGit(location, this.connectorConfiguration, this.serverOptionIndex, emptyCredentialsProvider, false);
        allFiles.removeIf(AbapGitRepositoryConnection::isDdicFileFromSAP);
        return allFiles;
    }
}

