/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem;

import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.RepositoryCloneOption;
import com.teamscale.index.gitbridge.abap.AbapGitImporterUtils;
import com.teamscale.index.repository.sap.abapsystem.AbapSystemDescription;
import com.teamscale.index.repository.sap.abapsystem.EUpdateMode;
import com.teamscale.index.repository.sap.abapsystem.rfc.ClearHistoryIdExecuter;
import com.teamscale.index.repository.sap.abapsystem.rfc.SapSystemCommunicationException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import org.apache.commons.lang3.RandomStringUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class AbapRepositoryUtil {
    private static final int EXPORT_HISTORY_ID_MAX_LENGTH = 20;
    private static final int RANDOM_ID_LENGTH = 8;
    private static final String REPOSITORY_IDENTIFIER_FILE = ".repository-id";
    public static int CLEAR_LOCK_SUCCESS_RETURN_CODE = 0;

    private static String createRepositoryIdentifier(String configurationId) {
        String configuratoinIdPart = configurationId.replaceAll("[^A-Za-z0-9]", "");
        String randomPart = RandomStringUtils.randomAlphabetic((int)8).toUpperCase();
        return StringUtils.truncate((String)configuratoinIdPart, (int)11) + "_" + randomPart;
    }

    public static String getOrCreateRepositoryIdentifier(File repositoryLocation, String configurationId) throws StorageException {
        File repositoryIdentifierFile = new File(repositoryLocation, REPOSITORY_IDENTIFIER_FILE);
        if (!repositoryIdentifierFile.exists()) {
            return AbapRepositoryUtil.createNewRepositoryIdentifierFile(repositoryIdentifierFile, configurationId);
        }
        try {
            return FileSystemUtils.readFileUTF8((File)repositoryIdentifierFile);
        }
        catch (IOException e) {
            throw new StorageException("Unable to read ABAP repository identifier file " + String.valueOf(repositoryIdentifierFile), (Throwable)e);
        }
    }

    public static boolean repositoryIdentifierExists(File repositoryLocation) {
        File repositoryIdentifierFile = new File(repositoryLocation, REPOSITORY_IDENTIFIER_FILE);
        return repositoryIdentifierFile.exists();
    }

    private static String createNewRepositoryIdentifierFile(File repositoryIdentifierFile, String configurationId) throws StorageException {
        String id = AbapRepositoryUtil.createRepositoryIdentifier(configurationId);
        try {
            FileSystemUtils.writeFileUTF8((File)repositoryIdentifierFile, (String)id);
        }
        catch (IOException e) {
            throw new StorageException("Unable to create ABAP repostiroy identifier file " + String.valueOf(repositoryIdentifierFile), (Throwable)e);
        }
        return id;
    }

    public static CanonicalFile buildRepositoryLocation(String configurationId, String subPath, ServerOptionIndex serverOptionIndex) throws StorageException {
        Path repositoryPath = RepositoryCloneOption.getRepositoryCloneDirectory((ServerOptionIndex)serverOptionIndex).resolve(Path.of("sap.abap.system", configurationId, subPath));
        try {
            return new CanonicalFile(repositoryPath.toFile());
        }
        catch (IOException e) {
            throw new StorageException("Cannot access repository location at '" + String.valueOf(repositoryPath) + "'", (Throwable)e);
        }
    }

    public static CanonicalFile buildRepositoryLocation(String configurationId, ServerOptionIndex serverOptionIndex) throws StorageException {
        return AbapRepositoryUtil.buildRepositoryLocation(configurationId, "", serverOptionIndex);
    }

    static String createZipFileName(EUpdateMode updateMode, String exportHistoryId, LocalDateTime time) {
        String suffix = updateMode.name().substring(0, 4).toLowerCase();
        return String.format("abap_export_%s_%s_%s.zip", exportHistoryId, AbapGitImporterUtils.ZIP_TIMESTAMP_FORMATTER.format(time), suffix);
    }

    public static int clearAbapHistoryIdLock(String sapConfigurationId, ServerOptionIndex serverOptionIndex, AbapSystemDescription abapSystemDescription) throws StorageException, SapSystemCommunicationException {
        ClearHistoryIdExecuter clearHistoryIdExecuter = new ClearHistoryIdExecuter(sapConfigurationId, abapSystemDescription, serverOptionIndex);
        clearHistoryIdExecuter.executeRfcFunction();
        return clearHistoryIdExecuter.getReturnCode();
    }

    private AbapRepositoryUtil() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

