/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.tfs.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.index.repository.tfs.client.model.AssociatedWorkItemsResponseBody;
import com.teamscale.index.repository.tfs.client.model.ETfvcChangesetOrder;
import com.teamscale.index.repository.tfs.client.model.ETfvcRecursionType;
import com.teamscale.index.repository.tfs.client.model.ETfvcVersionType;
import com.teamscale.index.repository.tfs.client.model.GetChangesResponseBody;
import com.teamscale.index.repository.tfs.client.model.GetChangesetsBody;
import com.teamscale.index.repository.tfs.client.model.GetItemsBody;
import com.teamscale.index.repository.tfs.client.model.GetItemsResponseBody;
import com.teamscale.index.repository.tfs.client.model.TfvcBranchesResponseBody;
import com.teamscale.index.repository.tfs.client.model.TfvcChangesetDto;
import com.teamscale.index.repository.tfs.client.model.TfvcChangesetResponseBody;
import okhttp3.ResponseBody;
import org.checkerframework.checker.nullness.qual.Nullable;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface IAzureDevOpsTfvcRestApi
extends IRetrofitApi {
    public static final int MAX_CHANGES_PER_QUERY = 0x7FFFFFFE;
    public static final String API_VERSION_QUERY = "?api-version=4.1";
    public static final String CHANGESET_ID_PATH_PARAM = "changesetID";
    public static final String API_BASE_PATH = "_apis/tfvc/";
    public static final String CHANGESETS_PATH = "_apis/tfvc/changesets";
    public static final String CHANGESET_PATH = "_apis/tfvc/changesets/{changesetID}";
    public static final String ITEM_PATH_QUERY_PARAM = "searchCriteria.itemPath";
    public static final String PATH_QUERY_PARAM = "path";
    public static final String MAX_RESULTS_QUERY_PARAM = "$top";
    public static final String ORDER_QUERY_PARAM = "$orderby";
    public static final String VERSION_TYPE_QUERY_PARAM = "versionType";
    public static final String VERSION_QUERY_PARAM = "version";
    public static final String RECURSION_LEVEL_QUERY_PARAM = "recursionLevel";
    public static final String CHANGE_SET_ID_PATH_PARAM = "changeSetId";

    @POST(value="_apis/tfvc/itembatch?api-version=4.1")
    public GetItemsResponseBody getItems(@Body GetItemsBody var1) throws ServiceCallException;

    @GET(value="_apis/tfvc/changesets/{changesetID}/changes?api-version=4.1")
    public GetChangesResponseBody getChangesForChangeset(@Path(value="changesetID") int var1, @Query(value="$top") int var2) throws ServiceCallException;

    @GET(value="_apis/tfvc/changesets/{changesetID}?api-version=4.1")
    public TfvcChangesetDto getChangeset(@Path(value="changesetID") int var1, @Query(value="maxChangeCount") int var2) throws ServiceCallException;

    @POST(value="_apis/tfvc/changesetsbatch?api-version=4.1")
    public TfvcChangesetResponseBody getChangesetBatch(@Body GetChangesetsBody var1) throws ServiceCallException;

    @GET(value="_apis/tfvc/changesets?api-version=4.1")
    public TfvcChangesetResponseBody getChangesetsBetweenRevisions(@Query(value="searchCriteria.fromId") String var1, @Query(value="searchCriteria.toId") String var2, @Query(value="searchCriteria.itemPath") String var3, @Query(value="$top") int var4, @Query(value="$orderby") @Nullable ETfvcChangesetOrder var5) throws ServiceCallException;

    @GET(value="_apis/tfvc/changesets?api-version=4.1")
    public TfvcChangesetResponseBody getChangesetsBetweenDates(@Query(value="searchCriteria.fromDate") String var1, @Query(value="searchCriteria.toDate") String var2, @Query(value="searchCriteria.itemPath") String var3, @Query(value="$top") int var4, @Query(value="$orderby") @Nullable ETfvcChangesetOrder var5) throws ServiceCallException;

    @GET(value="_apis/tfvc/branches?api-version=4.1")
    public TfvcBranchesResponseBody getBranchesBelowPath(@Query(value="scopePath") String var1, @Query(value="includeDeleted") boolean var2) throws ServiceCallException;

    @GET(value="_apis/tfvc/items?api-version=4.1")
    public ResponseBody getItemContent(@Query(value="path") String var1, @Query(value="recursionLevel") ETfvcRecursionType var2, @Query(value="version") String var3, @Query(value="versionType") ETfvcVersionType var4, @Query(value="download") boolean var5, @Query(value="includeContent") boolean var6) throws ServiceCallException;

    @GET(value="_apis/tfvc/changesets/{changeSetId}/workitems?api-version=4.1")
    public AssociatedWorkItemsResponseBody getAssociatedWorkItems(@Path(value="changeSetId") int var1) throws ServiceCallException;
}

