/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.ContainerSynchronizerBase;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;

public class ContainerIndexSynchronizer
extends ContainerSynchronizerBase {
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex contentIndex;

    @Override
    protected List<String> getContentHashesForAddedOrChangedKeys(List<String> addedOrChangedKeys) throws StorageException {
        List<TokenElementInfo> fileInfos = this.contentIndex.getTokenElements(addedOrChangedKeys);
        return fileInfos.stream().map(BasicTokenElementInfo::getText).map(ContainerInfo::calculateContentDigest).collect(Collectors.toList());
    }

    @Override
    protected List<String> getAddedOrChangedFiles() {
        return this.contentDelta.getAddedOrChangedKeysAsStrings();
    }

    @Override
    protected List<String> getDeletedKeys() {
        return this.contentDelta.getDeletedKeysAsStrings();
    }
}

