/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.resource.utils.EResourceType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;

@IndexValueClass
public class ContainerInfo
implements Serializable {
    public static final String CONTAINER_HASH_PREFIX = "container:";
    private static final long serialVersionUID = 1L;
    private static final String UNIFORM_PATH_PROPERTY = "uniformPath";
    @JsonProperty(value="uniformPath")
    private final String uniformPath;
    @JsonProperty(value="deepestRelativePathWithMoreThanOneChild")
    private @NonNull String deepestRelativePathWithMoreThanOneChild = "";
    @JsonProperty(value="children")
    private final Map<String, String> children = new HashMap<String, String>();

    @JsonCreator
    public ContainerInfo(@JsonProperty(value="uniformPath") String uniformPath) {
        this.uniformPath = uniformPath;
    }

    public Set<String> getChildren() {
        return this.children.keySet();
    }

    public String getHash(String uniformPath) {
        return this.children.get(uniformPath);
    }

    public boolean childIsAContainer(String childName) {
        return this.children.get(childName).startsWith(CONTAINER_HASH_PREFIX);
    }

    public Map<String, EResourceType> getChildrenWithResourceType() {
        return this.children.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ContainerInfo.valueToResourceType((String)entry.getValue())));
    }

    private static EResourceType valueToResourceType(@Nullable String value) {
        if (value == null) {
            return EResourceType.UNKNOWN;
        }
        if (value.startsWith(CONTAINER_HASH_PREFIX)) {
            return EResourceType.CONTAINER;
        }
        return EResourceType.FILE;
    }

    public String getUniformPath() {
        return this.uniformPath;
    }

    public void insertOrUpdateChildElementWithHash(String uniformPath, String hash) {
        this.children.put(uniformPath, hash);
    }

    public void insertOrUpdateChildElementWithHash(UniformPath uniformPath, String hash) {
        this.insertOrUpdateChildElementWithHash(uniformPath.toStringAsMigrationFrontier(), hash);
    }

    public void insertOrUpdateChildContainer(String uniformPath, String deepestRelativePathWithMoreThanOneChild) {
        this.children.put(uniformPath, CONTAINER_HASH_PREFIX + deepestRelativePathWithMoreThanOneChild);
    }

    public void insertOrUpdateChildContainer(UniformPath uniformPath, String deepestRelativePathWithMoreThanOneChild) {
        this.insertOrUpdateChildContainer(uniformPath.toStringAsMigrationFrontier(), deepestRelativePathWithMoreThanOneChild);
    }

    public void deleteChild(String uniformPath) {
        this.children.remove(uniformPath);
    }

    public void removeMatchingChildren(Predicate<String> condition) {
        this.getChildren().removeIf(path -> {
            Object fullPath = this.uniformPath.isEmpty() ? path : this.uniformPath + UniformPathUtils.SEPARATOR + path;
            if (this.childIsAContainer((String)path)) {
                fullPath = (String)fullPath + UniformPathUtils.SEPARATOR + StringUtils.stripPrefix((String)this.children.get(path), (String)CONTAINER_HASH_PREFIX);
            }
            return condition.test((String)fullPath);
        });
    }

    public @NonNull String getDeepestRelativePathWithMoreThanOneChild() {
        return this.deepestRelativePathWithMoreThanOneChild;
    }

    public void setDeepestRelativePathWithMoreThanOneChild(@NonNull String deepestRelativePathWithMoreThanOneChild) {
        this.deepestRelativePathWithMoreThanOneChild = deepestRelativePathWithMoreThanOneChild;
    }

    public static String calculateContentDigest(String content) {
        return Long.toHexString(XXHashUtils.xxhash64((String)content));
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public int size() {
        return this.children.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.uniformPath + " (" + this.deepestRelativePathWithMoreThanOneChild + "):");
        for (String key : CollectionUtils.sort(this.children.keySet())) {
            builder.append(" " + key + "->" + this.children.get(key));
        }
        return builder.toString();
    }
}

