/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.path_lookup;

import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.LoggingMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupUtils;
import com.teamscale.index.resource.path_lookup.PreloadedMatchingPathsLookup;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.logging.RateLimiting;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

public interface IPathLookupIndex
extends IProjectIndex {
    public PairList<String, String> getEntries() throws StorageException;

    default public PreloadedMatchingPathsLookup createPreloadedLookup() throws StorageException {
        return PreloadedMatchingPathsLookup.createFrom(this, this.getPathSuffixSizeRatioThreshold());
    }

    default public IMatchingPathsLookup createLoggingPreloadedLookup() throws StorageException {
        return this.createLoggingPreloadedLookup(new RateLimiting(100));
    }

    default public IMatchingPathsLookup createLoggingPreloadedLookup(@NonNull RateLimiting loggingRateLimit) throws StorageException {
        return LoggingMatchingPathsLookup.wrap(this.createPreloadedLookup(), loggingRateLimit);
    }

    default public double getPathSuffixSizeRatioThreshold() {
        return PathLookupUtils.readPathLookupThresholdProperty();
    }
}

