/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy;

import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class WorkItemHistoryAccessOptionExpander {
    private final SupplierWithException<ProjectConfiguration, StorageException> projectConfiguration = SupplierWithException.memoize(() -> ProjectConfigurationUtils.getProjectConfiguration((ProjectStorageSystem)projectStorageSystem));

    public WorkItemHistoryAccessOptionExpander(ProjectStorageSystem projectStorageSystem) {
    }

    public List<HistoryAccessOption> expandHistoryAccessOption(UniformPath uniformPath, HistoryAccessOption baseOption) throws StorageException {
        String branchName = baseOption.getBranchName();
        if (SpecItemIndex.isRequirementsManagementConnectorBranch(baseOption.getBranchName())) {
            return List.of(baseOption);
        }
        return (List)TeamscaleIssueId.calculateBasedOnUniformPath((UniformPath)uniformPath, ignored -> SpecItemIndex.getPossibleSpecItemBranches(branchName, (ProjectConfiguration)this.projectConfiguration.get()).stream().map(arg_0 -> ((HistoryAccessOption)baseOption).cloneToBranchedAccessOption(arg_0)).toList(), (ignored, connectorId) -> List.of(this.resolveHistoryAccessOptionForConnector(baseOption, (String)connectorId)), (ignored, itemId) -> List.of(this.resolveHistoryAccessOptionForConnector(baseOption, itemId.getConnectorId())));
    }

    public List<HistoryAccessOption> expandHistoryAccessOption(List<UniformPath> uniformPaths, HistoryAccessOption baseOption) throws StorageException {
        UniformPath prefix = UniformPathUtils.reduceToCommonPrefix(uniformPaths);
        return this.expandHistoryAccessOption(prefix, baseOption);
    }

    public HistoryAccessOption resolveHistoryAccessOptionForConnector(HistoryAccessOption historyAccessOption, String connectorId) throws StorageException {
        Set<String> requirementManagementConnectorIds = SpecItemIndex.getRequirementManagementConnectorIds((ProjectConfiguration)this.projectConfiguration.get());
        if (requirementManagementConnectorIds.contains(connectorId)) {
            return historyAccessOption.cloneToBranchedAccessOption(SpecItemIndex.matchRequirementsManagementConnectorIdToBranchName(connectorId));
        }
        return historyAccessOption;
    }
}

