/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.sap;

import java.io.Serializable;
import java.time.Instant;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class AbapTeamscaleSync
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final State state;
    private final Instant commitTime;

    public static AbapTeamscaleSync createInitiated() {
        return new AbapTeamscaleSync(State.INITIATED, null);
    }

    public static AbapTeamscaleSync createUpdating(Instant commitTime) {
        CCSMAssert.isNotNull((Object)commitTime, (String)"Commit time must be set.");
        return new AbapTeamscaleSync(State.UPDATING, commitTime);
    }

    public static AbapTeamscaleSync createDone(AbapTeamscaleSync updatingSynchronization) {
        Optional<Instant> commitTime = updatingSynchronization.getCommitTime();
        CCSMAssert.isTrue((boolean)commitTime.isPresent(), (String)"Commit time must be present in state DONE.");
        return new AbapTeamscaleSync(State.DONE, commitTime.get());
    }

    public static AbapTeamscaleSync createCanceled() {
        return new AbapTeamscaleSync(State.CANCELED, null);
    }

    public State getState() {
        return this.state;
    }

    public Optional<Instant> getCommitTime() {
        return Optional.ofNullable(this.commitTime);
    }

    private AbapTeamscaleSync(State state, Instant commitTime) {
        this.state = state;
        this.commitTime = commitTime;
    }

    @IndexValueClass
    public static enum State {
        INITIATED,
        UPDATING,
        DONE,
        CANCELED;

    }
}

