/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.search;

import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.search.CodeSearchIndex;
import com.teamscale.index.search.SearchSource;
import com.teamscale.index.search.SearchToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ByteArrayWrapper;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="code-search-inverted", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={SearchToken.class})
public class InvertedCodeSearchIndex
extends IndexBase
implements IProjectIndex {
    public static final String INDEX_NAME = "code-search-inverted";
    private static final byte[] OLD_DATA_PREFIX = new byte[]{111};
    private static final byte[] INVERTED_DATA_PREFIX = new byte[]{105};

    public InvertedCodeSearchIndex(IStore store) {
        super(store);
    }

    public List<SearchToken> getOldTokensBySource(Collection<SearchSource> sources) throws StorageException {
        return CodeSearchIndex.getTokensBySource(sources, (IStore)this.store, OLD_DATA_PREFIX, this.store.getAbbreviator());
    }

    public void updateOldTokens(CodeSearchIndex codeSearchIndex, KeyDelta codeSearchDelta) throws StorageException {
        if (!codeSearchDelta.getDeletedKeys().isEmpty()) {
            this.store.remove(CollectionUtils.map((Collection)codeSearchDelta.getDeletedKeys(), key -> ByteArrayUtils.concat((byte[][])new byte[][]{OLD_DATA_PREFIX, key.getBytes()})));
        }
        if (!codeSearchDelta.getAddedOrChangedKeys().isEmpty()) {
            List rawKeys = CollectionUtils.map((Collection)codeSearchDelta.getAddedOrChangedKeys(), ByteArrayWrapper::getBytes);
            List<byte[]> rawData = codeSearchIndex.getRawData(rawKeys);
            this.store.put(PairList.zip((List)CollectionUtils.map((Collection)rawKeys, key -> ByteArrayUtils.concat((byte[][])new byte[][]{OLD_DATA_PREFIX, key})), rawData));
        }
    }

    public List<List<SearchToken>> getTokensByText(List<String> tokenTexts) throws StorageException {
        List values = this.store.get(CollectionUtils.map(tokenTexts, text -> InvertedCodeSearchIndex.makeInvertedDataKey(text.toLowerCase())));
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        return CollectionUtils.map((Collection)values, value -> CodeSearchIndex.deserializeTokens(value, null, abbreviator));
    }

    public void updateInvertedTokens(List<String> tokenTexts, List<List<SearchToken>> tokenLists) throws StorageException {
        CCSMAssert.isTrue((tokenTexts.size() == tokenLists.size() ? 1 : 0) != 0, (String)"Both input list must have same number of elements!");
        ArrayList<byte[]> keysToRemove = new ArrayList<byte[]>();
        PairList keysValues = new PairList();
        for (int i = 0; i < tokenTexts.size(); ++i) {
            byte[] key = InvertedCodeSearchIndex.makeInvertedDataKey(tokenTexts.get(i));
            if (CollectionUtils.isNullOrEmpty((Collection)tokenLists.get(i))) {
                keysToRemove.add(key);
                continue;
            }
            keysValues.add((Object)key, (Object)CodeSearchIndex.serializeTokens(tokenLists.get(i), this.store.getAbbreviator()));
        }
        if (!keysToRemove.isEmpty()) {
            this.store.remove(keysToRemove);
        }
        if (!keysValues.isEmpty()) {
            this.store.put(keysValues);
        }
    }

    private static byte[] makeInvertedDataKey(String tokenText) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{INVERTED_DATA_PREFIX, StringUtils.stringToBytes((String)tokenText)});
    }

    public List<SearchToken> getTokensByPrefix(String prefix, int maxResults) throws StorageException {
        List keys = StorageUtils.listKeysStartingWith((byte[])InvertedCodeSearchIndex.makeInvertedDataKey(prefix), (IStore)this.store);
        if (maxResults > 0 && keys.size() > maxResults) {
            keys = keys.subList(0, maxResults);
        }
        List values = this.store.get(keys);
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        return CollectionUtils.map((Collection)values, value -> CodeSearchIndex.deserializeTokens(value, null, abbreviator).get(0));
    }
}

