/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.analysis.naming_convention;

import com.teamscale.index.simulink.analysis.SimulinkFindingAnalysis;
import com.teamscale.index.simulink.analysis.SimulinkFindingAnalysisBase;
import com.teamscale.index.simulink.analysis.naming_convention.SubExpressionBasedNamingConventionAnalysisUtils;
import eu.cqse.check.framework.core.CheckException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkBusUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@SimulinkFindingAnalysis(name="Simulink naming", description="Marks names that violate the naming conventions.", group="Naming", qualityIndicator="Comprehensibility")
public class SimulinkNamingConventionAnalysis
extends SimulinkFindingAnalysisBase {
    private SubExpressionBasedNamingConventionAnalysisUtils.SubjectNamePattern standardPortNamePattern;
    private SubExpressionBasedNamingConventionAnalysisUtils.SubjectNamePattern rootPortNamePattern;
    private SubExpressionBasedNamingConventionAnalysisUtils.SubjectNamePattern subsystemInstancePattern;
    private SubExpressionBasedNamingConventionAnalysisUtils.SubjectNamePattern signalNamePattern;
    private SubExpressionBasedNamingConventionAnalysisUtils.SubjectNamePattern librarySubsystemNamePattern;
    private SubExpressionBasedNamingConventionAnalysisUtils.SubjectNamePattern globalLibrarySubsystemNamePattern;
    private Pattern globalLibraryPathPattern;
    private Set<String> ignoredBlockTypes;
    private Pattern systemIdentifierPattern;
    private boolean enableReferenceCheck;

    public void initialize(Map<String, String> parameters) throws ConQATException, CheckException {
        Map<String, String> subExpressionMap = SubExpressionBasedNamingConventionAnalysisUtils.parseSubExpressions(parameters.get("Sub Expressions"));
        this.standardPortNamePattern = SimulinkNamingConventionAnalysis.buildPattern("Port-Name Pattern (standard)", parameters, subExpressionMap);
        this.rootPortNamePattern = SimulinkNamingConventionAnalysis.buildPattern("Port-Name Pattern (Root Ports)", parameters, subExpressionMap);
        this.subsystemInstancePattern = SimulinkNamingConventionAnalysis.buildPattern("Subsystem Instance Pattern", parameters, subExpressionMap);
        this.signalNamePattern = SimulinkNamingConventionAnalysis.buildPattern("Signal-Name Pattern", parameters, subExpressionMap);
        this.librarySubsystemNamePattern = SimulinkNamingConventionAnalysis.buildPattern("Library Subsystem Pattern", parameters, subExpressionMap);
        this.globalLibrarySubsystemNamePattern = SimulinkNamingConventionAnalysis.buildPattern("Global Library Subsystem Pattern", parameters, subExpressionMap);
        if (subExpressionMap.containsKey("$SYS")) {
            this.systemIdentifierPattern = Pattern.compile(subExpressionMap.get("$SYS"));
        }
        this.enableReferenceCheck = Boolean.valueOf(parameters.get("Enable checking of reference blocks"));
        String globalLibraryPathPattern = parameters.get("Global Library Path Pattern");
        if (!globalLibraryPathPattern.isEmpty()) {
            this.globalLibraryPathPattern = Pattern.compile(globalLibraryPathPattern);
        }
        this.ignoredBlockTypes = new HashSet<String>(CollectionUtils.map((Collection)StringUtils.splitToList((String)parameters.get("Ignored Block Types"), (String)","), String::trim));
    }

    private static SubExpressionBasedNamingConventionAnalysisUtils.SubjectNamePattern buildPattern(String patternName, Map<String, String> analysisParameters, Map<String, String> subExpressionMap) throws CheckException {
        return SubExpressionBasedNamingConventionAnalysisUtils.buildPattern(patternName, analysisParameters.get(patternName), subExpressionMap);
    }

    @Override
    protected void analyzeModel(SimulinkModel model) {
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (this.ignoredBlockTypes.contains(block.getType())) continue;
            this.analyzeBlock(block, model);
        }
    }

    private void analyzeBlock(SimulinkBlock block, SimulinkModel model) {
        boolean isTopLevelBlock = block.getParent() == model;
        switch (block.getType()) {
            case "SubSystem": {
                if (!isTopLevelBlock || !model.isLibraryModel()) {
                    this.checkBlockName(block, this.subsystemInstancePattern);
                    break;
                }
                if (this.isInGlobalLibraryPath(this.uniformPath)) {
                    this.checkBlockName(block, this.globalLibrarySubsystemNamePattern);
                    break;
                }
                this.checkBlockName(block, this.librarySubsystemNamePattern);
                break;
            }
            case "Inport": 
            case "InportShadow": 
            case "Outport": {
                if (isTopLevelBlock && !model.isLibraryModel() && !model.isSubsystem()) {
                    this.checkBlockName(block, this.rootPortNamePattern);
                    break;
                }
                this.checkBlockName(block, this.standardPortNamePattern);
                break;
            }
            case "Reference": {
                this.checkReferenceName(block);
                break;
            }
            case "SignalSpecification": {
                this.checkBlockName(block, this.signalNamePattern);
                break;
            }
        }
    }

    private void checkReferenceName(SimulinkBlock block) {
        if (!this.enableReferenceCheck) {
            return;
        }
        String referencedBlockName = block.getReferencedBlockInfo().getBlockName();
        String[] referenceParts = referencedBlockName.split("/");
        if (referenceParts.length >= 2) {
            String referencedSubsystemName = referenceParts[1];
            String subsystemName = StringUtils.getFirstPart((String)referencedSubsystemName, (char)'_');
            if (this.systemIdentifierPattern != null && this.systemIdentifierPattern.matcher(subsystemName).matches() && !block.getName().startsWith(subsystemName + "_")) {
                this.createAndReportFindingForBlock(block, block.getName() + " must begin with \"" + subsystemName + "_\" because it references " + referencedBlockName);
            }
        }
    }

    private boolean isInGlobalLibraryPath(String uniformPath) {
        return this.globalLibraryPathPattern != null && this.globalLibraryPathPattern.matcher(uniformPath).find();
    }

    private void checkBlockName(SimulinkBlock block, SubExpressionBasedNamingConventionAnalysisUtils.SubjectNamePattern blockNamePattern) {
        String name = SimulinkNamingConventionAnalysis.getBlockNameToCheck(block);
        Optional<SubExpressionBasedNamingConventionAnalysisUtils.PatternFindingMessage> message = SubExpressionBasedNamingConventionAnalysisUtils.checkName(name, blockNamePattern);
        if (message.isPresent()) {
            this.createAndReportFindingForBlock(block, message.get().fullMessage());
        }
    }

    private static String getBlockNameToCheck(SimulinkBlock block) {
        if (SimulinkBusUtils.isBusElementPort((SimulinkBlock)block)) {
            return block.getParameter("InterfaceData.PortName");
        }
        return block.getName();
    }

    @Override
    protected String getFindingIndexPartition() {
        return "Comprehensibility";
    }
}

