/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type;

import com.google.common.collect.Multimap;
import com.teamscale.index.simulink.signal_type.SimulinkResolvedInformationUpdater;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLink;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.SimulinkResolvedInformation;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;

class SimulinkDataTypeUpdater
extends SimulinkResolvedInformationUpdater {
    private static final Set<String> DEFAULT_DATA_TYPES = Set.of("double", "Unknown", "NOT_CONNECTED");

    public SimulinkDataTypeUpdater(SimulinkResolvedDataTypes resolvedDataTypes, Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks, List<SimulinkDataDictionary> dictionaries) {
        super((SimulinkResolvedInformation)resolvedDataTypes, typeLinks, dictionaries);
    }

    public SimulinkDataTypeUpdater(SimulinkResolvedDataTypes resolvedDataTypes, Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks) {
        this(resolvedDataTypes, typeLinks, List.of());
    }

    @Override
    protected boolean updateRequired(Set<String> currentDataTypes, String newDataType) {
        if (newDataType == null) {
            return false;
        }
        HashSet<String> possibleDataTypes = new HashSet<String>(currentDataTypes);
        possibleDataTypes.add(newDataType);
        if (currentDataTypes.contains("Bus") || currentDataTypes.stream().anyMatch(dataType -> dataType.startsWith("Bus: "))) {
            return false;
        }
        if (DEFAULT_DATA_TYPES.containsAll(currentDataTypes) && newDataType.startsWith("Bus")) {
            return true;
        }
        if (currentDataTypes.size() == 1 && ((String)CollectionUtils.getAny(currentDataTypes)).equals("Unknown") && !newDataType.equals("Unknown")) {
            return true;
        }
        String updatedDataType = SimulinkDataTypeUtils.selectDataTypeWithLargestRange(possibleDataTypes);
        return !currentDataTypes.contains(newDataType) && updatedDataType.equals(newDataType);
    }
}

