/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type.dimensions;

import com.google.common.collect.Multimap;
import com.teamscale.index.simulink.LibraryBlockIdentifier;
import com.teamscale.index.simulink.signal_type.SimulinkLibraryLoader;
import com.teamscale.index.simulink.signal_type.SimulinkPropagationUtils;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLink;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLinkExtractor;
import com.teamscale.index.simulink.signal_type.dimensions.SimulinkDimensionUpdater;
import com.teamscale.index.simulink.signal_type.dimensions.SimulinkDimensionalityResolverFromInput;
import com.teamscale.index.simulink.signal_type.dimensions.SimulinkResolveDimensionsOfSourceBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkMatrix;
import org.conqat.lib.simulink.model.SimulinkMatrixFactory;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDimensions;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class SimulinkDimensionalityResolver {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SimulinkResolvedDimensions resolvedDimensions;
    private final SimulinkModel model;
    private final SimulinkLibraryLoader libraryLoader;
    private final Map<String, SimulinkDimensionalityResolver> dimensionsForEmbeddedModels;
    private final Map<String, SimulinkMatrix> resolvedInPortDimensions = new HashMap<String, SimulinkMatrix>();
    private final Map<String, SimulinkMatrix> resolvedOutPortDimensions = new HashMap<String, SimulinkMatrix>();
    private final SimulinkBlock referencedBlock;

    public SimulinkDimensionalityResolver(SimulinkModel model, SimulinkLibraryLoader libraryLoader) {
        this(model, libraryLoader, new SimulinkResolvedDimensions());
    }

    public SimulinkDimensionalityResolver(SimulinkModel model, SimulinkLibraryLoader libraryLoader, SimulinkResolvedDimensions resolvedDimensions) {
        this(model, libraryLoader, resolvedDimensions, new HashMap<String, SimulinkDimensionalityResolver>());
    }

    public SimulinkDimensionalityResolver(SimulinkModel model, SimulinkLibraryLoader libraryLoader, SimulinkResolvedDimensions resolvedDimensions, Map<String, SimulinkDimensionalityResolver> dimensionsForEmbeddedModels) {
        this(model, libraryLoader, resolvedDimensions, dimensionsForEmbeddedModels, SimulinkPropagationUtils.extractReferencedBlock(model, null));
    }

    public SimulinkDimensionalityResolver(SimulinkModel model, SimulinkLibraryLoader libraryLoader, SimulinkResolvedDimensions resolvedDimensions, Map<String, SimulinkDimensionalityResolver> dimensionsForEmbeddedModels, @NonNull SimulinkBlock analysisRootBlock) {
        this.model = model;
        this.libraryLoader = libraryLoader;
        this.resolvedDimensions = resolvedDimensions;
        this.dimensionsForEmbeddedModels = dimensionsForEmbeddedModels;
        this.referencedBlock = analysisRootBlock;
    }

    public Map<String, SimulinkResolvedDimensions> resolveDimensions(Set<LibraryBlockIdentifier> visitedLibraryBlocks) throws StorageException {
        Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks = new SimulinkTypeLinkExtractor(this.referencedBlock).extractDimensionLinks();
        SimulinkDimensionUpdater updater = new SimulinkDimensionUpdater(this.resolvedDimensions, typeLinks);
        SimulinkResolveDimensionsOfSourceBlocks resolver = new SimulinkResolveDimensionsOfSourceBlocks(updater);
        resolver.resolveDimensionality(this.model);
        this.initializeInPortDimensions();
        SimulinkDimensionalityResolverFromInput inputResolver = new SimulinkDimensionalityResolverFromInput(this.libraryLoader, this.resolvedDimensions, updater, typeLinks, this.dimensionsForEmbeddedModels, visitedLibraryBlocks);
        this.dimensionsForEmbeddedModels.putAll(inputResolver.resolveDimensions(this.model));
        this.setResolvedOutPortDimensions();
        return this.fetchResult();
    }

    public Map<String, SimulinkMatrix> getResolvedOutPortDimensions() {
        return this.resolvedOutPortDimensions;
    }

    public void addResolvedInPortDimension(String portIndex, SimulinkMatrix resolvedDimension) {
        this.resolvedInPortDimensions.put(portIndex, resolvedDimension);
    }

    private void initializeInPortDimensions() {
        for (SimulinkBlock inPortBlock : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)this.referencedBlock, (boolean)true, (boolean)true)) {
            String port;
            if (!SimulinkUtils.isInport((SimulinkBlock)inPortBlock) || !this.resolvedInPortDimensions.containsKey(port = SimulinkUtils.getPortParameterOrDefault((SimulinkBlock)inPortBlock))) continue;
            SimulinkMatrix matrix = this.resolvedInPortDimensions.get(port);
            this.resolvedDimensions.setInformationForBlock(inPortBlock, matrix);
        }
    }

    private void setResolvedOutPortDimensions() {
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)this.referencedBlock, (boolean)true, (boolean)true)) {
            if (!SimulinkUtils.isOutport((SimulinkBlock)block) || block.getParent() == this.model && !this.model.isLibraryModel() && this.referencedBlock != this.model) continue;
            String port = SimulinkUtils.getPortParameterOrDefault((SimulinkBlock)block);
            ArrayList dimensionalityForPortsInBlock = new ArrayList(this.resolvedDimensions.getDimensionalityForAllPorts(block));
            if (dimensionalityForPortsInBlock.isEmpty()) {
                LOGGER.warn("Port dimensionality could not be determined for block {} in {}. Skipping it.", (Object)block.buildQualifiedName(), (Object)this.model.getUniformPath());
                continue;
            }
            this.resolvedOutPortDimensions.put(port, (SimulinkMatrix)dimensionalityForPortsInBlock.get(0));
            String portNumber = SimulinkUtils.getPortParameterOrDefault((SimulinkBlock)block);
            String dimension = ((SimulinkMatrix)dimensionalityForPortsInBlock.get(0)).toDimensionFormat();
            this.resolvedDimensions.setInformationForBlock(block.getParent(), portNumber, SimulinkMatrixFactory.createMatrixFromDimensions((String)dimension));
        }
    }

    private Map<String, SimulinkResolvedDimensions> fetchResult() {
        HashMap<String, SimulinkResolvedDimensions> results = new HashMap<String, SimulinkResolvedDimensions>();
        results.put(this.model.getUniformPath(), this.resolvedDimensions);
        this.dimensionsForEmbeddedModels.forEach((uniformPathChildren, analysis) -> results.put((String)uniformPathChildren, analysis.resolvedDimensions));
        return results;
    }

    public SimulinkResolvedDimensions getResolvedDimensions() {
        return this.resolvedDimensions;
    }
}

