/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type.dimensions;

import com.teamscale.index.simulink.signal_type.dimensions.SimulinkDimensionUpdater;
import com.teamscale.index.simulink.signal_type.dimensions.SimulinkDimensionUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkMatrix;
import org.conqat.lib.simulink.model.SimulinkMatrixFactory;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

class SimulinkResolveDimensionsOfSourceBlocks {
    private final SimulinkDimensionUpdater updater;

    SimulinkResolveDimensionsOfSourceBlocks(SimulinkDimensionUpdater updater) {
        this.updater = updater;
    }

    void resolveDimensionality(SimulinkModel model) {
        List<SimulinkBlock> blocks = SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)true, (boolean)true).stream().filter(SimulinkResolveDimensionsOfSourceBlocks::isSourceBlockWithoutInheritance).toList();
        for (SimulinkBlock block : blocks) {
            this.resolveDimensionality(block);
        }
    }

    private void resolveDimensionality(SimulinkBlock block) {
        boolean vectorAs1D;
        Set<String> constantValues = SimulinkResolveDimensionsOfSourceBlocks.getConstantValues(block);
        Optional<SimulinkMatrix> matrix = SimulinkDimensionUtils.getLargestMatrixFromConstantValues(constantValues, vectorAs1D = SimulinkResolveDimensionsOfSourceBlocks.interpretVectorParamsAs1D(block));
        if (matrix.isPresent()) {
            this.updater.updateDimension(block, matrix.get());
            return;
        }
        Optional<String> portDimension = SimulinkResolveDimensionsOfSourceBlocks.getPortDimension(block);
        portDimension.ifPresent(s -> this.updater.updateDimension(block, SimulinkMatrixFactory.createMatrixFromDimensions((String)s)));
    }

    private static boolean isSourceBlockWithoutInheritance(SimulinkBlock block) {
        return (block.getInPorts().isEmpty() || SimulinkUtils.isOutport((SimulinkBlock)block)) && !"-1".equals(block.getParameter("PortDimensions"));
    }

    private static boolean interpretVectorParamsAs1D(SimulinkBlock block) {
        return "on".equals(block.getParameter("VectorParams1D"));
    }

    private static Set<String> getConstantValues(SimulinkBlock block) {
        HashSet<String> values = new HashSet<String>();
        values.add(block.getParameter("Seed"));
        if (block.isOfSourceType("Band-Limited White Noise.")) {
            values.add(block.getParameter("Cov"));
        } else if (block.isOfSourceType("chirp")) {
            values.add(block.getParameter("f1"));
            values.add(block.getParameter("f2"));
            values.add(block.getParameter("T"));
        } else if (block.isOfType("Constant") || block.isOfSourceType("Enumerated Constant")) {
            values.add(block.getParameter("Value"));
        } else if (block.isOfType("DiscretePulseGenerator") || block.isOfType("SignalGenerator") || block.isOfType("Sin")) {
            values.add(block.getParameter("Amplitude"));
        } else if (block.isOfType("Step")) {
            values.add(block.getParameter("Before"));
            values.add(block.getParameter("After"));
        } else if (block.isOfSourceType("Ramp")) {
            values.add(block.getParameter("slope"));
            values.add(block.getParameter("start"));
            values.add(block.getParameter("InitialOutput"));
        }
        return values.stream().filter(v -> v != null && !v.isEmpty()).collect(Collectors.toSet());
    }

    private static Optional<String> getPortDimension(SimulinkBlock block) {
        String value = block.getParameter("PortDimensions");
        if (value != null && !value.isEmpty() && !"-1".equals(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

