/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.system_info;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.UserSatisfactionFeedbackIndex;
import com.teamscale.index.system_info.JavaSystemInfoFragment;
import com.teamscale.index.system_info.OperatingSystemInfoFragment;
import com.teamscale.index.system_info.StorageAbbreviatorStatisticsFragment;
import com.teamscale.index.system_info.SystemHealthFragment;
import com.teamscale.index.system_info.SystemInfoFragmentBase;
import com.teamscale.index.system_info.SystemInfoIndex;
import com.teamscale.index.system_info.SystemLoadFragment;
import java.io.File;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DurationUtils;
import oshi.SystemInfo;

public class SystemInfoCollector {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Duration UPDATE_PERIOD = DurationUtils.ONE_MINUTE;
    private static final Set<String> LOGGED_ERROR_MESSAGES = new HashSet<String>();
    private final SystemInfoIndex systemInfoIndex;
    private final @Nullable File storageDirectory;
    private final ServerOptionIndex serverOptionIndex;
    private final IndexLayer indexLayer;
    private SystemInfo systemInfo;
    private long[] recentCpuLoadTicks;

    public SystemInfoCollector(ServerOptionIndex serverOptionIndex, SystemInfoIndex systemInfoIndex, IndexLayer indexLayer, @Nullable File storageDirectory) {
        this.serverOptionIndex = serverOptionIndex;
        this.storageDirectory = storageDirectory;
        this.systemInfoIndex = systemInfoIndex;
        this.indexLayer = indexLayer;
        try {
            this.systemInfo = new SystemInfo();
            this.recentCpuLoadTicks = this.systemInfo.getHardware().getProcessor().getSystemCpuLoadTicks();
            this.insertOneTimeInfoFragments(this.systemInfo);
        }
        catch (Throwable t) {
            SystemInfoCollector.logErrorOnce(t);
        }
    }

    private void insertOneTimeInfoFragments(SystemInfo systemInfo) throws StorageException {
        this.systemInfoIndex.insertFragment(new OperatingSystemInfoFragment(systemInfo.getOperatingSystem()));
    }

    public void start() {
        Timer timer = new Timer(this.getClass().getSimpleName(), true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    SystemInfoCollector.this.insertFragment(new JavaSystemInfoFragment());
                    SystemInfoCollector.this.insertFragment(new SystemLoadFragment(SystemInfoCollector.this.systemInfo, SystemInfoCollector.this.storageDirectory, SystemInfoCollector.this.serverOptionIndex, (UserSatisfactionFeedbackIndex)SystemInfoCollector.this.indexLayer.openGlobalIndex(UserSatisfactionFeedbackIndex.class), UPDATE_PERIOD.toMillis(), SystemInfoCollector.this.recentCpuLoadTicks));
                    SystemInfoCollector.this.insertFragment(new StorageAbbreviatorStatisticsFragment(UPDATE_PERIOD.toMillis()));
                    SystemInfoCollector.this.insertFragment(new SystemHealthFragment(UPDATE_PERIOD.toMillis(), SystemInfoCollector.this.indexLayer));
                    SystemInfoCollector.this.recentCpuLoadTicks = SystemLoadFragment.determineCpuLoadTicks(SystemInfoCollector.this.systemInfo);
                }
                catch (Throwable t) {
                    SystemInfoCollector.logErrorOnce(t);
                }
            }
        }, 0L, UPDATE_PERIOD.toMillis());
    }

    public void insertFragment(SystemInfoFragmentBase fragment) throws StorageException {
        this.systemInfoIndex.insertFragment(fragment);
    }

    private static void logErrorOnce(Throwable t) {
        String errorMessage = t.getMessage();
        if (!LOGGED_ERROR_MESSAGES.contains(errorMessage)) {
            LOGGER.error("Failed to obtain information from OSHI library: {}", (Object)errorMessage, (Object)t);
            LOGGED_ERROR_MESSAGES.add(errorMessage);
        }
    }
}

