/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.system_info;

import com.teamscale.index.system_info.SystemInfoFragmentBase;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;

@Index(name="system-info", options={EStorageOption.COMPRESSED}, valueClasses={SystemInfoFragmentBase.class})
public class SystemInfoIndex
extends IndexBase
implements IGlobalIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String INDEX_NAME = "system-info";
    private static final String SEPARATOR = "###";

    public SystemInfoIndex(IStore store) {
        super(store);
    }

    public void insertFragment(SystemInfoFragmentBase fragment) throws StorageException {
        this.store.putWithString(SystemInfoIndex.makeKey(fragment), StorageUtils.serialize((Serializable)fragment));
    }

    public List<SystemInfoFragmentBase> getAllValidFragments() throws StorageException {
        Instant now = DateTimeUtils.now();
        PairList keysValues = StorageUtils.listStringKeysAndValues((IStore)this.store);
        ArrayList<String> keysToDelete = new ArrayList<String>();
        ArrayList<SystemInfoFragmentBase> fragments = new ArrayList<SystemInfoFragmentBase>();
        for (int i = 0; i < keysValues.size(); ++i) {
            try {
                fragments.add((SystemInfoFragmentBase)StorageUtils.deserialize((byte[])((byte[])keysValues.getSecond(i))));
                continue;
            }
            catch (StorageException e) {
                String key = (String)keysValues.getFirst(i);
                LOGGER.warn("Deleting broken system info fragment stored at key '" + key + "'", (Throwable)e);
                keysToDelete.add(key);
            }
        }
        if (!keysToDelete.isEmpty()) {
            this.store.removeWithStrings(keysToDelete);
        }
        Set processesWithUpdatedFragment = fragments.stream().filter(SystemInfoFragmentBase::isUpdatedAtLeastDaily).filter(info -> info.isUpToDate(now)).map(SystemInfoFragmentBase::getProcessId).collect(Collectors.toSet());
        return CollectionUtils.filter(fragments, fragment -> processesWithUpdatedFragment.contains(fragment.getProcessId()) && fragment.isUpToDate(now));
    }

    private static String makeKey(SystemInfoFragmentBase fragment) {
        return fragment.getProcessId() + SEPARATOR + fragment.getClass().getSimpleName();
    }

    public void removeEntries(String processId) throws StorageException {
        this.store.removeByPrefix(processId + SEPARATOR);
    }
}

