/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testcoverage;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.testcoverage.BranchCoverageToCoverableLinesAdjuster;
import com.teamscale.index.testcoverage.CoverableBranchAnalyzer;
import com.teamscale.index.testcoverage.CoverageMetricSynchronizerBase;
import com.teamscale.index.testcoverage.LineCoverageToBranchCoverageConverter;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.volume.CodeBranch;
import org.conqat.engine.sourcecode.coverage.volume.ConditionalStatementSubtypes;
import org.conqat.engine.sourcecode.coverage.volume.CoverableVolumeUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class BranchCoverageMetricSynchronizer
extends CoverageMetricSynchronizerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String ENABLE_BRANCH_COVERAGE_PARAMETER_NAME = "enable-branch-coverage";
    public static final String COVERABLE_BRANCHES_PARTITION = "test-coverable-branches";
    public static final String COVERED_BRANCHES_PARTITION = "test-covered-branches";
    @StepParameter(value="enable-branch-coverage")
    private CodeScopeAware<Boolean> enableBranchCoverage;
    private final Map<String, CoverableBranchAnalyzer.CoverableBranchInfo> branchCoverage = Collections.synchronizedMap(new HashMap());

    @Override
    public void execute() throws StorageException, ExecutionException {
        this.executeInParallelBatches(this.getDeltaKeys(), this::collectBranchCoverage);
        super.execute();
    }

    private void collectBranchCoverage(List<String> uniformPaths) throws StorageException {
        List<TokenElementInfo> elementsAtPaths = this.contentIndex.getTokenElements(uniformPaths, false);
        for (TokenElementInfo elementAtPath : elementsAtPaths) {
            if (elementAtPath == null || !ConditionalStatementSubtypes.supportsLanguageForBranchCoverage((ELanguage)elementAtPath.getLanguage())) continue;
            try {
                CoverableBranchAnalyzer.CoverableBranchInfo elementBranchInfo = CoverableBranchAnalyzer.extractBranchInfo(elementAtPath);
                this.branchCoverage.put(elementAtPath.getUniformPath(), elementBranchInfo);
            }
            catch (ConQATException e) {
                LOGGER.error("Could not determine branch info for " + elementAtPath.getUniformPath() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private List<String> getDeltaKeys() {
        return new ArrayList<String>(this.getUniformPathsToUpdate());
    }

    @Override
    protected void updateCoverageMetrics(CoverageMetricSynchronizerBase.CoveragePartitionGroup partitionGroup, List<String> pathsToUpdate) throws StorageException {
        PairList<String, LineCoverageInfo> coverageInfos = this.getLineCoverageInfosToUpdate(partitionGroup, false, pathsToUpdate);
        PairList coverableBranchesData = new PairList();
        PairList coveredBranchesData = new PairList();
        for (Pair coverageInfoPair : coverageInfos) {
            this.calculateBranchCoverage((String)coverageInfoPair.getFirst(), (LineCoverageInfo)coverageInfoPair.getSecond(), (PairList<String, Double>)coverableBranchesData, (PairList<String, Double>)coveredBranchesData);
        }
        this.storeData((PairList<String, Double>)coverableBranchesData, (PairList<String, Double>)coveredBranchesData, partitionGroup);
    }

    private void calculateBranchCoverage(String uniformPath, LineCoverageInfo lineCoverageInfo, PairList<String, Double> coverableBranchesData, PairList<String, Double> coveredBranchesData) {
        CoverableBranchAnalyzer.CoverableBranchInfo coverableBranchInfo = this.branchCoverage.get(uniformPath);
        if (coverableBranchInfo == null) {
            coveredBranchesData.add((Object)uniformPath, (Object)0.0);
            coverableBranchesData.add((Object)uniformPath, (Object)Math.min(1, lineCoverageInfo.getCoverableLines()));
            return;
        }
        List<CodeBranch> coverableBranchInfos = coverableBranchInfo.getCodeBranches();
        LineCoverageToBranchCoverageConverter converter = new LineCoverageToBranchCoverageConverter(lineCoverageInfo, coverableBranchInfos);
        int coveredBranchCount = converter.calculateNumberOfCoveredBranches();
        int coverableBranchCount = coverableBranchInfos.size();
        if (CoverableVolumeUtils.useCoverableVolumeFilterForCpp((String)uniformPath)) {
            coverableBranchCount = BranchCoverageToCoverableLinesAdjuster.calculateAdjustedCoverableBranchCount(coverableBranchInfos, lineCoverageInfo);
        }
        if (coveredBranchCount > coverableBranchCount) {
            LOGGER.error("Branch coverage error for " + uniformPath + ": coveredBranchCount = " + coveredBranchCount + " coverableBranchCount = " + coverableBranchCount);
            coverableBranchCount = coveredBranchCount;
        }
        coverableBranchesData.add((Object)uniformPath, (Object)coverableBranchCount);
        coveredBranchesData.add((Object)uniformPath, (Object)coveredBranchCount);
    }

    @Override
    protected String getDefaultCoverablePartitionName() {
        return COVERABLE_BRANCHES_PARTITION;
    }

    @Override
    protected String getDefaultCoveredPartitionName() {
        return COVERED_BRANCHES_PARTITION;
    }

    @Override
    protected CodeScopeAware<Boolean> getCodeScopeAwareCoverageEnablement() {
        return this.enableBranchCoverage;
    }
}

