/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testcoverage;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.volume.CodeBranch;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CompactLines;

public class BranchCoverageToCoverableLinesAdjuster {
    private static final Logger LOGGER = LogManager.getLogger();

    public static int calculateAdjustedCoverableBranchCount(List<CodeBranch> coverableBranches, LineCoverageInfo lineCoverageInfo) {
        return BranchCoverageToCoverableLinesAdjuster.filterCoverableBranches(coverableBranches, lineCoverageInfo).size();
    }

    public static List<CodeBranch> filterCoverableBranches(List<CodeBranch> coverableBranches, LineCoverageInfo lineCoverageInfo) {
        CompactLines linesWithCoverage = lineCoverageInfo.getAllCoverableLines();
        if (linesWithCoverage.isEmpty()) {
            return coverableBranches;
        }
        return CollectionUtils.filter(coverableBranches, branch -> BranchCoverageToCoverableLinesAdjuster.isBranchOrCounterBranchCoverable(branch, linesWithCoverage));
    }

    private static boolean isBranchOrCounterBranchCoverable(CodeBranch branch, CompactLines linesWithCoverage) {
        if (branch.isBranchNotPresent()) {
            return BranchCoverageToCoverableLinesAdjuster.isBranchCoverable(branch.getCounterBranch(), linesWithCoverage);
        }
        return BranchCoverageToCoverableLinesAdjuster.isBranchCoverable(branch, linesWithCoverage) || BranchCoverageToCoverableLinesAdjuster.isBranchCoverable(branch.getCounterBranch(), linesWithCoverage);
    }

    private static boolean isBranchCoverable(CodeBranch branch, CompactLines linesWithCoverage) {
        if (branch == null) {
            return false;
        }
        CCSMAssert.isFalse((boolean)branch.isBranchNotPresent(), (String)"Branch must exist");
        if (branch.getStartLine() > branch.getEndLine()) {
            LOGGER.warn("Encountered branch with start line after end line: " + String.valueOf(branch));
            return false;
        }
        return linesWithCoverage.containsAny(branch.getStartLine(), branch.getEndLine());
    }
}

