/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.abap.traces;

import com.teamscale.index.testgap.abap.AbapTableDumpXmlHandler;
import com.teamscale.index.testgap.abap.ScovIdFeature;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.conqat.lib.commons.xml.XMLUtils;
import org.xml.sax.SAXException;

public final class AbapTraceUtils {
    private static ScovIdFeature createFeature(Map<EColumns, String> record) {
        return new ScovIdFeature(record.get((Object)EColumns.OBJNAME), record.get((Object)EColumns.CLASS), record.get((Object)EColumns.TYPE), record.get((Object)EColumns.NAME));
    }

    public static Map<ScovIdFeature, Long> readExecutionCounts(String xmlContent) throws ConQATException {
        AbapTableDumpXmlHandler<EColumns> parser = new AbapTableDumpXmlHandler<EColumns>(EColumns.class, "item");
        try {
            XMLUtils.parseSAX((String)xmlContent, parser);
        }
        catch (IOException | SAXException e) {
            throw new ConQATException("Unable to parse report", (Throwable)e);
        }
        HashMap<ScovIdFeature, Long> entries = new HashMap<ScovIdFeature, Long>();
        for (Map<EColumns, String> row : parser.getRecords()) {
            long count = Long.parseLong(row.get((Object)EColumns.PB_CNT_CUM));
            entries.merge(AbapTraceUtils.createFeature(row), count, Long::sum);
        }
        return entries;
    }

    private AbapTraceUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    private static enum EColumns {
        PROGNAME,
        OBJTYPE,
        OBJNAME,
        TYPE,
        NAME,
        CLASS,
        PB_CNT_CUM,
        PB_RBX_CUM,
        PB_CNT_CUR,
        PB_RBX_CUR;

    }
}

