/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.dotnet;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Index(name="dot-net-program-versions", options={EStorageOption.BACKUP, EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK})
public class DotNetVersionIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "dot-net-program-versions";
    private static final Logger LOGGER = LogManager.getLogger();
    private final ValueIndex<CommitDescriptor> delegate;

    public DotNetVersionIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public CommitDescriptor setCommitForVersionUnlessItExists(String version, CommitDescriptor newCommit) throws StorageException {
        CommitDescriptor oldCommit = (CommitDescriptor)this.delegate.getValue(version);
        if (oldCommit != null && !oldCommit.equals((Object)newCommit)) {
            LOGGER.warn("You uploaded new symbol files for an already existing version, but the timestamps for both uploads are different (was " + String.valueOf(oldCommit) + ", is now " + String.valueOf(newCommit) + "). Using the timestamp from the first upload and merging the mappings from both uploads.");
            return oldCommit;
        }
        this.delegate.setValue(version, (Object)newCommit);
        return newCommit;
    }

    public PairList<String, CommitDescriptor> getAllVersions() throws StorageException {
        return this.delegate.getAllEntries();
    }

    public void setVersions(PairList<String, CommitDescriptor> versions) throws StorageException {
        this.delegate.setValues(versions);
    }

    public @Nullable CommitDescriptor getVersionCommit(String versionName) throws StorageException {
        return (CommitDescriptor)this.delegate.getValue(versionName);
    }

    public void removeVersion(String versionName) throws StorageException {
        this.delegate.removeValue(versionName);
    }
}

