/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.treemap;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.treemap.MethodBasedTreeMapSerializationUtils;
import com.teamscale.index.testgap.treemap.TestGapTreeMapWrapperSerializer;
import com.teamscale.index.testgap.treemap.TgaMethodTreeMapNode;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;

@JsonSerialize(using=TestGapTreeMapWrapperSerializer.class)
public class TestGapTreeMapWrapper {
    private static final String TREEMAP_PROPERTY = "treemap";
    private static final String STATE_COUNTER_PROPERTY = "stateCounter";
    private static final String RATIO_PROPERTY = "ratio";
    private static final String END_COMMIT_PROPERTY = "endCommit";
    private static final String BASELINE_TIMESTAMP_PROPERTY = "baselineTimestamp";
    private static final String USED_PARTITIONS_PROPERTY = "usedPartitions";
    private static final String USED_CROSS_ANNOTATION_PROJECTS_PROPERTY = "usedCrossAnnotationProjects";
    private static final String TGA_ASSESSMENT_TYPE = "tgaAssessmentType";
    @JsonProperty(value="treemap")
    private final TgaMethodTreeMapNode treemap;
    @JsonProperty(value="stateCounter")
    private final CounterSet<ETestGapState> stateCounter;
    @JsonProperty(value="ratio")
    private final double ratio;
    @JsonProperty(value="endCommit")
    private final CommitDescriptor endCommit;
    @JsonProperty(value="baselineTimestamp")
    private final long baselineTimestamp;
    @JsonProperty(value="usedPartitions")
    private final List<String> usedPartitions;
    @JsonProperty(value="usedCrossAnnotationProjects")
    private final Collection<PublicProjectId> usedCrossAnnotationProjects;
    @JsonProperty(value="tgaAssessmentType")
    private final ETgaAssessmentType tgaAssessmentType;

    @JsonCreator
    public TestGapTreeMapWrapper(@JsonProperty(value="treemap") TgaMethodTreeMapNode treemap, @JsonProperty(value="stateCounter") CounterSet<ETestGapState> stateCounter, @JsonProperty(value="ratio") double ratio, @JsonProperty(value="endCommit") CommitDescriptor endCommit, @JsonProperty(value="baselineTimestamp") long baselineTimestamp, @JsonProperty(value="usedPartitions") List<String> usedPartitions, @JsonProperty(value="usedCrossAnnotationProjects") Collection<PublicProjectId> usedCrossAnnotationProjects, @JsonProperty(value="tgaAssessmentType") ETgaAssessmentType tgaAssessmentType) {
        this.treemap = treemap;
        this.stateCounter = stateCounter;
        this.ratio = ratio;
        this.endCommit = endCommit;
        this.baselineTimestamp = baselineTimestamp;
        this.usedPartitions = usedPartitions;
        this.usedCrossAnnotationProjects = usedCrossAnnotationProjects;
        this.tgaAssessmentType = tgaAssessmentType;
    }

    public String serializeToJson() {
        StringBuilder result = new StringBuilder("{");
        TestGapTreeMapWrapper.appendCounters(result, STATE_COUNTER_PROPERTY, this.stateCounter);
        MethodBasedTreeMapSerializationUtils.append(result, RATIO_PROPERTY, this.ratio);
        MethodBasedTreeMapSerializationUtils.append(result, BASELINE_TIMESTAMP_PROPERTY, this.baselineTimestamp);
        MethodBasedTreeMapSerializationUtils.append(result, END_COMMIT_PROPERTY, this.endCommit);
        MethodBasedTreeMapSerializationUtils.append(result, TREEMAP_PROPERTY, this.treemap);
        MethodBasedTreeMapSerializationUtils.append(result, USED_PARTITIONS_PROPERTY, this.usedPartitions);
        MethodBasedTreeMapSerializationUtils.append(result, USED_CROSS_ANNOTATION_PROJECTS_PROPERTY, CollectionUtils.map(this.usedCrossAnnotationProjects, ProjectIdBase::toString));
        MethodBasedTreeMapSerializationUtils.append(result, TGA_ASSESSMENT_TYPE, this.tgaAssessmentType.name());
        result.deleteCharAt(result.length() - 1);
        return result.append("}").toString();
    }

    private static void appendCounters(StringBuilder builder, String key, CounterSet<ETestGapState> counters) {
        MethodBasedTreeMapSerializationUtils.appendKey(builder, key);
        builder.append(JsonUtils.serializeToJSON(counters));
        builder.append(",");
    }

    public TgaMethodTreeMapNode getTreemap() {
        return this.treemap;
    }

    public CounterSet<ETestGapState> getStateCounter() {
        return this.stateCounter;
    }

    public Double getRatio() {
        return this.ratio;
    }

    public List<String> getUsedPartitions() {
        return this.usedPartitions;
    }

    public Collection<PublicProjectId> getUsedCrossAnnotationProjects() {
        return this.usedCrossAnnotationProjects;
    }
}

