/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.trend;

import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.trend.NewlyCoveredMethodsIndex;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.uniformpath.UniformPath;

class TouchedFilesCalculator {
    private final NewlyCoveredMethodsIndex newlyCoveredMethodsIndex;
    private final RepositoryLogFileIndex logFileIndex;
    private final List<String> partitions;
    private final UniformPath sourcePathPrefix;
    private final FunctionWithException<CommitDescriptor, ExternalResultsPartitionLastUpdateIndex, StorageException> partitionLastUpdateIndexFactory;
    private SetMap<CommitDescriptor, UniformPath> touchedFilePerCommit;
    private SetMap<CommitDescriptor, MethodLocation> newlyCoveredMethodsPerCommit;
    private final Set<String> notUpdatedPartitions;

    public TouchedFilesCalculator(NewlyCoveredMethodsIndex newlyCoveredMethodsIndex, RepositoryLogFileIndex logFileIndex, List<String> partitions, UniformPath sourcePathPrefix, FunctionWithException<CommitDescriptor, ExternalResultsPartitionLastUpdateIndex, StorageException> partitionLastUpdateIndexFactory) {
        this.newlyCoveredMethodsIndex = newlyCoveredMethodsIndex;
        this.logFileIndex = logFileIndex;
        this.partitions = partitions;
        this.notUpdatedPartitions = new HashSet<String>(partitions);
        this.sourcePathPrefix = sourcePathPrefix;
        this.partitionLastUpdateIndexFactory = partitionLastUpdateIndexFactory;
    }

    public void preloadTouchedFiles(List<CommitDescriptor> commitsToPreload) throws StorageException {
        this.touchedFilePerCommit = this.logFileIndex.getCodePathsByCommits(commitsToPreload, this.sourcePathPrefix);
    }

    public void preloadNewlyCoveredMethods(List<CommitDescriptor> coverageOrMergeCommits, boolean isExecutionOnly) throws StorageException {
        this.newlyCoveredMethodsPerCommit = this.newlyCoveredMethodsIndex.getNewlyCoveredMethodLocations(coverageOrMergeCommits, this.partitions, isExecutionOnly ? NewlyCoveredMethodsIndex.ENewlyCoveredType.EXECUTED : NewlyCoveredMethodsIndex.ENewlyCoveredType.EXECUTED_AFTER_CHANGE);
        this.newlyCoveredMethodsPerCommit.removeIf(location -> !location.getUniformPath().hasAncestor(this.sourcePathPrefix));
    }

    public Set<UniformPath> calculateTouchedFilesForCommit(CommitDescriptor commit) {
        return (Set)this.touchedFilePerCommit.getCollectionOrEmpty((Object)commit);
    }

    public Set<MethodLocation> calculateNewlyCoveredMethodsForCommit(CommitDescriptor commit) {
        return (Set)this.newlyCoveredMethodsPerCommit.getCollectionOrEmpty((Object)commit);
    }

    public Set<String> requiresFullPartitionUpdate(ParentedCommitDescriptor commit, boolean isExecutionOnly) throws StorageException {
        if (!isExecutionOnly) {
            return Collections.emptySet();
        }
        ExternalResultsPartitionLastUpdateIndex partitionLastUpdateIndex = (ExternalResultsPartitionLastUpdateIndex)this.partitionLastUpdateIndexFactory.apply((Object)commit);
        UnmodifiableList partitionsUpdatedWithCommit = partitionLastUpdateIndex.getPartitionsUpdatedWithCommit((CommitDescriptor)commit).getFirstList();
        HashSet partitionsUpdatedFirstTime = CollectionUtils.intersectionSet((Collection)partitionsUpdatedWithCommit, (Collection[])new Collection[]{this.notUpdatedPartitions});
        this.notUpdatedPartitions.removeAll(partitionsUpdatedFirstTime);
        return partitionsUpdatedFirstTime;
    }
}

