/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testimpact;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.testimpact.CommitAndRevision;
import com.teamscale.index.testimpact.ETestPrioritizationStrategy;
import com.teamscale.index.testimpact.TiaPartitionsQueryParams;
import com.teamscale.index.testimpact.TiaTestFilterQueryParams;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class TiaRequestOptions {
    public static final String BASELINE_COMMIT_PARAMETER_NAME = "baseline";
    public static final String END_COMMIT_PARAMETER_NAME = "end";
    public static final String BASELINE_REVISION_PARAMETER_NAME = "baseline-revision";
    public static final String END_REVISION_PARAMETER_NAME = "end-revision";
    public static final String REPOSITORY_PARAMETER_NAME = "repository";
    public static final String ENSURE_PROCESSED_PARAMETER_NAME = "ensure-processed";
    private static final String PRIORITIZATION_STRATEGY = "prioritization-strategy";
    @JsonProperty(value="baseline")
    @QueryParam(value="baseline")
    @Parameter(description="The baseline commit (exclusive). This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\"")
    @DefaultValue(value="1")
    private UnresolvedCommitDescriptor baselineCommit;
    @JsonProperty(value="end")
    @QueryParam(value="end")
    @Parameter(description="The end commit (inclusive). This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\"")
    private UnresolvedCommitDescriptor endCommit;
    @JsonProperty(value="baselineRevision")
    @QueryParam(value="baseline-revision")
    @Parameter(description="The baseline revision (exclusive). If both revision and commit are given, the revision will be preferred.")
    private String baselineRevision;
    @JsonProperty(value="endRevision")
    @QueryParam(value="end-revision")
    @Parameter(description="The end revision (inclusive). If both revision and commit are given, the revision will be preferred.")
    private String endRevision;
    @JsonProperty(value="repository")
    @QueryParam(value="repository")
    @Parameter(description="When using the revision parameter, this parameter allows to pass a repository name which is used to identify the correct commit in situations where the same revision exists in multiple repositories.")
    private String repository;
    @BeanParam
    private TiaPartitionsQueryParams partitionInfo;
    @JsonProperty(value="prioritizationStrategy")
    @QueryParam(value="prioritization-strategy")
    @Parameter(description="The name of the test prioritization strategy")
    @DefaultValue(value="CHEAP_ADDITIONAL_COVERAGE_PER_TIME")
    private ETestPrioritizationStrategy prioritizationStrategy;
    @JsonProperty(value="ensureProcessed")
    @QueryParam(value="ensure-processed")
    @Parameter(description="If set to true the request will fail with '412 PRECONDITION FAILED' if the exact given end commit has not been processed yet and therefore data may not be up-to-date.")
    private boolean ensureProcessed;
    @BeanParam
    private TiaTestFilterQueryParams testFilterOptions;
    @QueryParam(value="max-exec-time")
    @JsonProperty(value="maxExecTime")
    @Parameter(description="The upper bound for the predicted test execution duration in milliseconds that the resulting test list should exhibit. All impacted tests that do not fit into this budget will be cut off.")
    private Long maxTestSuiteRuntime;
    @QueryParam(value="covering-path")
    @JsonProperty(value="coveringPath")
    @Parameter(description="Consider coverage within this given uniform path only.")
    private UniformPath coveringPath;

    public TiaRequestOptions() {
    }

    public TiaRequestOptions(UnresolvedCommitDescriptor baselineCommit, UnresolvedCommitDescriptor endCommit, TiaPartitionsQueryParams partitionInfo, ETestPrioritizationStrategy prioritizationStrategy, boolean ensureProcessed, TiaTestFilterQueryParams testFilterOptions, Long maxTestSuiteRuntime, UniformPath coveringPath) {
        this.baselineCommit = baselineCommit;
        this.endCommit = endCommit;
        this.partitionInfo = partitionInfo;
        this.prioritizationStrategy = prioritizationStrategy;
        this.ensureProcessed = ensureProcessed;
        this.testFilterOptions = testFilterOptions;
        this.maxTestSuiteRuntime = maxTestSuiteRuntime;
        this.coveringPath = coveringPath;
    }

    public CommitAndRevision getBaselineDescriptor() {
        return new CommitAndRevision(this.baselineCommit, this.baselineRevision, this.repository);
    }

    public CommitAndRevision getEndDescriptor() {
        return new CommitAndRevision(this.endCommit, this.endRevision, this.repository);
    }

    public TiaPartitionsQueryParams getPartitionInfo() {
        return this.partitionInfo;
    }

    public ETestPrioritizationStrategy getPrioritizationStrategy() {
        return this.prioritizationStrategy;
    }

    public boolean isEnsureProcessed() {
        return this.ensureProcessed;
    }

    public TiaTestFilterQueryParams getTestFilterOptions() {
        return this.testFilterOptions;
    }

    public Long getMaxTestSuiteRuntime() {
        return this.maxTestSuiteRuntime;
    }

    public UniformPath getCoveringPath() {
        return this.coveringPath;
    }
}

