/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking;

import com.google.common.collect.Lists;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.index.blacklisting.BranchAgnosticFindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.tracking.FindingDeltaUtils;
import com.teamscale.index.tracking.algorithm.EFindingIdentificationCriterion;
import com.teamscale.index.tracking.algorithm.TrackedElement;
import com.teamscale.index.tracking.algorithm.TrackedFindingMinHasher;
import com.teamscale.index.tracking.index.FindingIdentificationIndex;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.StatementPathElement;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ByteArrayWrapper;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.digest.Digester;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.VisibleForTesting;

public class FindingIdManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TEMP_ID_PREFIX = "TEMP_ID";
    private static final int MIN_MATCHING_CRITERIA = 3;
    private static final int MAX_CANDIDATES_PER_FINDING = 20;
    private static final double SIMILARITY_THRESHOLD = 0.5;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private FindingIdentificationIndex findingIdentificationIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BranchAgnosticFindingBlacklistIndex crossBranchBlacklistIndex;
    private String defaultBranchName;
    private int tempIdCounter = 0;
    private final Random random = new Random();

    public FindingIdManager() {
    }

    @VisibleForTesting
    FindingIdManager(FindingIdentificationIndex findingIdentificationIndex, BranchAgnosticFindingBlacklistIndex crossBranchBlacklistIndex) {
        this.findingIdentificationIndex = findingIdentificationIndex;
        this.crossBranchBlacklistIndex = crossBranchBlacklistIndex;
    }

    public void init(String defaultBranchName) {
        this.defaultBranchName = defaultBranchName;
    }

    public String getNextTempId() {
        return TEMP_ID_PREFIX + this.tempIdCounter++;
    }

    public Map<String, String> determineIds(List<TrackedFinding> findings, List<TrackedFinding> findingsAddedInBranch, Map<String, TrackedElement> trackedElementByUniformPath, CommitDescriptor currentCommit, TrackedFindingsByIdIndex trackedFindingsByIdIndex) throws StorageException {
        LOGGER.debug("About to determine IDs for " + findings.size() + " untracked findings");
        Set usedIds = CollectionUtils.mapToSet(findingsAddedInBranch, TrackedFinding::getId);
        ArrayList<String[]> candidatesByFindingId = new ArrayList<String[]>();
        ArrayList<Integer> bestMatchCriteriaCount = new ArrayList<Integer>();
        int batchSize = (Integer)TeamscaleSystemProperties.FINDING_TRACKING_BATCH_SIZE.getValue();
        for (List findingSubList : Lists.partition(findings, (int)batchSize)) {
            LOGGER.debug("Processing batch of " + findingSubList.size() + " findings");
            this.prepareCandidatesPerFindingId(findingSubList, trackedElementByUniformPath, candidatesByFindingId, bestMatchCriteriaCount);
        }
        usedIds.addAll(FindingIdManager.retrieveExistingNonDeadFindingIdsForCandidates(trackedFindingsByIdIndex, candidatesByFindingId));
        HashMap<String, String> oldToNewFindingIdMap = new HashMap<String, String>();
        for (int i : FindingIdManager.generateListIndexesInOrderOfExpectedMatchQuality(findings, bestMatchCriteriaCount)) {
            TrackedFinding currentFinding = findings.get(i);
            oldToNewFindingIdMap.put(currentFinding.getId(), this.determineBestId((String[])candidatesByFindingId.get(i), currentFinding, trackedFindingsByIdIndex, currentCommit, usedIds));
        }
        return oldToNewFindingIdMap;
    }

    private static List<Integer> generateListIndexesInOrderOfExpectedMatchQuality(List<TrackedFinding> findings, List<Integer> bestMatchCriteriaCount) {
        return IntStream.range(0, findings.size()).boxed().sorted(Comparator.comparing(bestMatchCriteriaCount::get).reversed()).collect(Collectors.toList());
    }

    private static Set<String> retrieveExistingNonDeadFindingIdsForCandidates(TrackedFindingsByIdIndex trackedFindingsByIdIndex, List<String[]> candidatesByFindingId) throws StorageException {
        HashSet allIds = new HashSet();
        for (String[] candidates : candidatesByFindingId) {
            if (candidates == null) continue;
            Collections.addAll(allIds, candidates);
        }
        LOGGER.debug("Loading possible findings for " + allIds.size() + " ids.");
        return trackedFindingsByIdIndex.getFindings(new ArrayList<String>(allIds)).stream().filter(finding -> finding != null && finding.getDeathCommit() == null).map(TrackedFinding::getId).collect(Collectors.toSet());
    }

    private void prepareCandidatesPerFindingId(List<TrackedFinding> findings, Map<String, TrackedElement> trackedElementByUniformPath, List<String[]> candidatesByFindingId, List<Integer> bestMatchCriteriaCount) throws StorageException {
        List<String>[] allPossibleIds = this.retrievePossibleIdLists(findings, trackedElementByUniformPath);
        Map<String, byte[]> findingIdToMinHash = this.getFindingIdToMinHashMapping(allPossibleIds);
        for (int i = 0; i < findings.size(); ++i) {
            CounterSet idCandidates = new CounterSet();
            for (int j = 0; j < EFindingIdentificationCriterion.SIZE; ++j) {
                idCandidates.incAll(allPossibleIds[i * EFindingIdentificationCriterion.SIZE + j]);
            }
            LOGGER.debug(() -> "Intermediate counter set has size " + idCandidates.getKeys().size());
            byte[] currentFindingMinHash = FindingIdManager.getMinHash(findings.get(i), trackedElementByUniformPath);
            FindingIdManager.removeDissimilarFindings(findingIdToMinHash, (CounterSet<String>)idCandidates, currentFindingMinHash);
            LOGGER.debug(() -> "Pruned counter set has size " + idCandidates.getKeys().size());
            if (idCandidates.isEmpty()) {
                candidatesByFindingId.add(null);
                bestMatchCriteriaCount.add(0);
                continue;
            }
            List sortedCandidates = CollectionUtils.limit((List)idCandidates.getKeysByValueDescending(), (int)20);
            candidatesByFindingId.add(sortedCandidates.toArray(new String[0]));
            bestMatchCriteriaCount.add(idCandidates.getValue((Object)((String)sortedCandidates.get(0))));
        }
    }

    private static void removeDissimilarFindings(Map<String, byte[]> findingIdToMinHash, CounterSet<String> idCandidates, byte[] currentFindingMinHash) {
        for (String findingId : new ArrayList(idCandidates.getKeys())) {
            if (!FindingIdManager.areNotSimilarEnough(currentFindingMinHash, idCandidates.getValue((Object)findingId), findingIdToMinHash.get(findingId)).booleanValue()) continue;
            idCandidates.remove((Object)findingId);
        }
    }

    private static byte[] getMinHash(TrackedFinding finding, Map<String, TrackedElement> trackedElementByUniformPath) {
        TrackedElement currentElement = trackedElementByUniformPath.get(finding.getLocation().getUniformPath());
        return TrackedFindingMinHasher.hashEncode(currentElement, finding);
    }

    private Map<String, byte[]> getFindingIdToMinHashMapping(List<String>[] allPossibleIds) throws StorageException {
        List<String> allFindingIds = Arrays.stream(allPossibleIds).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        List<byte[]> allMinHashes = this.findingIdentificationIndex.getMinHashesForFindingIds(allFindingIds);
        HashMap<String, byte[]> findingIdToMinHash = new HashMap<String, byte[]>();
        for (int i = 0; i < allFindingIds.size(); ++i) {
            byte[] minHash = allMinHashes.get(i);
            if (minHash == null) continue;
            findingIdToMinHash.put(allFindingIds.get(i), minHash);
        }
        return findingIdToMinHash;
    }

    private static Boolean areNotSimilarEnough(byte[] currentFindingMinHash, Integer value, byte[] candidateMinHash) {
        return value < 3 || value == 3 && candidateMinHash != null && currentFindingMinHash != null && TrackedFindingMinHasher.getSimilarity(currentFindingMinHash, candidateMinHash) < 0.5;
    }

    private @NonNull List<String>[] retrievePossibleIdLists(List<TrackedFinding> findings, Map<String, TrackedElement> trackedElementByUniformPath) throws StorageException {
        ListMap keyDeduplicationMap = new ListMap();
        ArrayList<Integer> skippedIndexes = new ArrayList<Integer>();
        int currentIndex = 0;
        for (TrackedFinding finding : findings) {
            TrackedElement element = trackedElementByUniformPath.get(finding.getLocation().getUniformPath());
            CCSMAssert.isNotNull((Object)element, (String)("Expected element to be present for " + finding.getLocation().getUniformPath()));
            for (EFindingIdentificationCriterion criterion : EFindingIdentificationCriterion.values()) {
                Optional<String> value = criterion.calculateCriterion((IndexFinding)finding, element);
                if (value.isEmpty()) {
                    skippedIndexes.add(currentIndex++);
                    continue;
                }
                keyDeduplicationMap.add((Object)new ByteArrayWrapper(FindingIdentificationIndex.createKey(criterion, value.get())), (Object)currentIndex++);
            }
        }
        ArrayList<byte[]> criterionAndValueKeys = new ArrayList<byte[]>(CollectionUtils.map((Collection)keyDeduplicationMap.getKeys(), ByteArrayWrapper::getBytes));
        List<List<String>> findingIdsForCriterionValue = this.findingIdentificationIndex.getFindingIdsForCriterionValues(criterionAndValueKeys);
        FindingIdManager.removeIdsOccurringInTooFewCriteria(criterionAndValueKeys, findingIdsForCriterionValue);
        return FindingIdManager.recreateFullPossibleIdLists((ListMap<ByteArrayWrapper, Integer>)keyDeduplicationMap, skippedIndexes, currentIndex, criterionAndValueKeys, findingIdsForCriterionValue);
    }

    private static void removeIdsOccurringInTooFewCriteria(List<byte[]> criterionAndValueKeys, List<List<String>> findingIdsForCriterionValue) {
        int i;
        SetMap criteriaByFindingsId = new SetMap();
        for (i = 0; i < criterionAndValueKeys.size(); ++i) {
            if (findingIdsForCriterionValue.get(i) == null) continue;
            EFindingIdentificationCriterion eFindingIdentificationCriterion = EFindingIdentificationCriterion.extractCriterion(criterionAndValueKeys.get(i));
            for (String id2 : findingIdsForCriterionValue.get(i)) {
                criteriaByFindingsId.add((Object)id2, (Object)eFindingIdentificationCriterion);
            }
        }
        for (i = 0; i < criterionAndValueKeys.size(); ++i) {
            if (findingIdsForCriterionValue.get(i) == null) continue;
            findingIdsForCriterionValue.get(i).removeIf(id -> ((Set)criteriaByFindingsId.getCollection(id)).size() < 3);
        }
    }

    @VisibleForTesting
    static @NonNull List<String>[] recreateFullPossibleIdLists(ListMap<ByteArrayWrapper, Integer> keyDeduplicationMap, List<Integer> skippedIndexes, int currentIndex, List<byte[]> criterionAndValueKeys, List<List<String>> findingIdsForCriterionValue) {
        List[] reconstructedResult = new List[currentIndex];
        for (int i = 0; i < criterionAndValueKeys.size(); ++i) {
            List entries = (List)keyDeduplicationMap.getCollection((Object)new ByteArrayWrapper(criterionAndValueKeys.get(i)));
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                int entry = (Integer)iterator.next();
                reconstructedResult[entry] = findingIdsForCriterionValue.get(i);
            }
        }
        for (int skippedIndex : skippedIndexes) {
            reconstructedResult[skippedIndex] = CollectionUtils.emptyList();
        }
        return reconstructedResult;
    }

    private String determineBestId(String[] idCandidates, TrackedFinding finding, TrackedFindingsByIdIndex trackedFindingsByIdIndex, CommitDescriptor currentCommit, Set<String> usedIds) throws StorageException {
        if (idCandidates != null) {
            for (String candidateId : idCandidates) {
                if (!usedIds.add(candidateId)) continue;
                return candidateId;
            }
        }
        return this.generateNewUnusedId(finding, trackedFindingsByIdIndex, currentCommit, usedIds);
    }

    private String generateNewUnusedId(TrackedFinding finding, TrackedFindingsByIdIndex trackedFindingsByIdIndex, CommitDescriptor currentCommit, Set<String> usedIds) throws StorageException {
        String calculated;
        int salt = 0;
        while (true) {
            calculated = this.calculateId((IndexFinding)finding, currentCommit, salt);
            salt = this.random.nextInt();
            if (usedIds.contains(calculated)) continue;
            usedIds.add(calculated);
            TrackedFinding existingFinding = trackedFindingsByIdIndex.getFinding(calculated);
            if (existingFinding == null) break;
        }
        return calculated;
    }

    void transferAllCrossBranchBlacklist(FindingBlacklistIndex blacklistIndex, TrackedFindingsByIdIndex trackedFindingsByIdIndex, long currentTimestamp, Set<String> newFindingIdCandidates) throws StorageException {
        List<FindingBlacklistInfo> crossBranchBlacklistInfos = this.crossBranchBlacklistIndex.getAllExistingBlacklistInfos();
        List blacklistInfoIds = CollectionUtils.map(crossBranchBlacklistInfos, FindingBlacklistInfo::getFindingId);
        List<FindingBlacklistInfo> currentBranchBlacklistInfos = blacklistIndex.getBlacklistInfos(blacklistInfoIds);
        List<TrackedFinding> trackedFindings = trackedFindingsByIdIndex.getFindings(blacklistInfoIds);
        PairList newBlackListInfos = new PairList();
        for (int i = 0; i < blacklistInfoIds.size(); ++i) {
            if (trackedFindings.get(i) == null && !newFindingIdCandidates.contains(blacklistInfoIds.get(i))) continue;
            FindingBlacklistInfo crossBranchBlacklistInfo = crossBranchBlacklistInfos.get(i);
            FindingBlacklistInfo currentBranchBlacklistInfo = currentBranchBlacklistInfos.get(i);
            if (currentBranchBlacklistInfo != null && currentBranchBlacklistInfo.getTimestamp() >= crossBranchBlacklistInfo.getTimestamp() || crossBranchBlacklistInfo.getTimestamp() > currentTimestamp) continue;
            newBlackListInfos.add((Object)crossBranchBlacklistInfo.getFindingId(), (Object)crossBranchBlacklistInfo);
        }
        blacklistIndex.setBlacklistInfos((PairList<String, FindingBlacklistInfo>)newBlackListInfos);
    }

    void transferBlacklistIfNeeded(List<String> candidates, FindingBlacklistIndex blacklistIndex, long currentTimestamp) throws StorageException {
        List<FindingBlacklistInfo> blacklistInfos = this.crossBranchBlacklistIndex.getExistingBlacklistInfos(candidates);
        PairList newBlackListInfos = new PairList();
        for (int i = 0; i < candidates.size(); ++i) {
            if (blacklistInfos.get(i) == null || blacklistInfos.get(i).getTimestamp() > currentTimestamp) continue;
            newBlackListInfos.add((Object)candidates.get(i), (Object)blacklistInfos.get(i));
        }
        blacklistIndex.setBlacklistInfos((PairList<String, FindingBlacklistInfo>)newBlackListInfos);
    }

    private String calculateId(IndexFinding finding, CommitDescriptor birthCommit, int salt) {
        String birthMarker = birthCommit.toServiceCallFormat();
        if (this.defaultBranchName.equals(birthCommit.getBranchName())) {
            birthMarker = Long.toString(birthCommit.getTimestamp());
        }
        String md5Content = finding.getTypeId() + ":" + FindingDeltaUtils.getNormalizedFindingMessage(finding) + ":" + birthMarker + ":" + FindingIdManager.getFindingLocationDescription(finding);
        if (salt != 0) {
            md5Content = md5Content + ":" + salt;
        }
        return Digester.createMD5Digest((String)md5Content);
    }

    static String getFindingLocationDescription(IndexFinding finding) {
        ElementLocation location = finding.getLocation();
        StringBuilder description = new StringBuilder(location.getUniformPath());
        if (location instanceof TextRegionLocation) {
            description.append(":").append(((TextRegionLocation)location).getRawStartOffset()).append("-").append(((TextRegionLocation)location).getRawEndOffset());
        } else if (location instanceof QualifiedNameLocation) {
            description.append(":").append(((QualifiedNameLocation)location).getQualifiedName());
        }
        for (int i = 0; i < finding.getStatementPath().size(); ++i) {
            StatementPathElement pathElement = (StatementPathElement)finding.getStatementPath().get(i);
            TextRegionLocation pathElementLocation = (TextRegionLocation)pathElement.getLocation();
            description.append(":").append(i).append("-").append(pathElement.getDescription()).append("-").append(pathElementLocation.getUniformPath()).append("-").append(pathElementLocation.getRawStartOffset()).append("-").append(pathElementLocation.getRawEndOffset()).append("-").append(StringUtils.concat((Iterable)pathElement.getPredecessorPathElements()));
        }
        return description.toString();
    }

    public void persistFindingsCharacteristics(SetMap<UniformPath, TrackedFinding> findingsByUniformPath, Map<String, TrackedElement> trackedElementByUniformPath) throws StorageException {
        SetMap keysAndFindingIds = new SetMap();
        PairList findingIdAndMinHash = new PairList();
        for (Map.Entry entry : findingsByUniformPath.entrySet()) {
            UniformPath uniformPath = (UniformPath)entry.getKey();
            Set findings = (Set)entry.getValue();
            if (CollectionUtils.isNullOrEmpty((Collection)findings)) continue;
            TrackedElement element = trackedElementByUniformPath.get(uniformPath.toString());
            if (element == null) {
                LOGGER.error("No pre-loaded element found for " + String.valueOf(uniformPath) + ". Findings were: " + StringUtils.concat((Iterable)findings, (String)"\n"));
                continue;
            }
            FindingIdManager.createCriterionsForFindings((SetMap<ByteArrayWrapper, ByteArrayWrapper>)keysAndFindingIds, findings, element);
            FindingIdManager.createMinHashesForFindings((PairList<String, byte[]>)findingIdAndMinHash, findings, element);
        }
        this.findingIdentificationIndex.addOrReplaceFindingMinHash((PairList<String, byte[]>)findingIdAndMinHash);
        this.findingIdentificationIndex.mergeCharacteristics((SetMap<ByteArrayWrapper, ByteArrayWrapper>)keysAndFindingIds);
    }

    private static void createMinHashesForFindings(PairList<String, byte[]> findingIdAndMinHash, Set<TrackedFinding> findings, TrackedElement element) {
        for (TrackedFinding finding : findings) {
            byte[] findingMinHash = TrackedFindingMinHasher.hashEncode(element, finding);
            if (findingMinHash == null) continue;
            findingIdAndMinHash.add((Object)finding.getId(), (Object)findingMinHash);
        }
    }

    private static void createCriterionsForFindings(SetMap<ByteArrayWrapper, ByteArrayWrapper> keysAndFindingIds, Set<TrackedFinding> findings, TrackedElement element) {
        for (TrackedFinding finding : findings) {
            CCSMAssert.isFalse((boolean)finding.getId().startsWith(TEMP_ID_PREFIX), (String)"Not expected to encounter dummy IDs at this point!");
            byte[] binaryFindingId = StringUtils.decodeFromHex((String)finding.getId());
            for (EFindingIdentificationCriterion criterion : EFindingIdentificationCriterion.values()) {
                criterion.calculateCriterion((IndexFinding)finding, element).ifPresent(value -> keysAndFindingIds.add((Object)new ByteArrayWrapper(FindingIdentificationIndex.createKey(criterion, value)), (Object)new ByteArrayWrapper(binaryFindingId)));
            }
        }
    }
}

