/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.tracking.algorithm;

import eu.cqse.check.framework.scanner.IToken;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ILookahead;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;

public class UpdateableTokenListLookahead
implements ILookahead<IToken, NeverThrownRuntimeException> {
    private final List<IToken> tokenList;
    private int currentIndex;

    public UpdateableTokenListLookahead(List<IToken> tokens, int index) {
        this.tokenList = tokens;
        this.setCurrentIndex(index);
    }

    public void setCurrentIndex(int index) {
        CCSMAssert.isFalse((index < 0 ? 1 : 0) != 0, (String)("Index must not be negative but was: " + index));
        this.currentIndex = index;
    }

    public IToken lookahead(int lookahead) throws NeverThrownRuntimeException {
        CCSMAssert.isFalse((lookahead < 0 ? 1 : 0) != 0, (String)("Lookahead must not be negative but was: " + lookahead));
        int index = this.currentIndex + lookahead;
        if (index >= this.tokenList.size()) {
            return null;
        }
        return this.tokenList.get(index);
    }
}

