/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.upload.cppcheck;

import com.teamscale.commons.service.XmlSerializationUtils;
import com.teamscale.index.configuration.tools.Rule;
import com.teamscale.index.upload.cppcheck.data.CppcheckError;
import com.teamscale.index.upload.cppcheck.data.CppcheckResults;
import com.teamscale.index.upload.cppcheck.data.ECppcheckSeverity;
import eu.cqse.check.framework.core.EFindingEnablement;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ProcessUtils;

public class CppCheckRulesExtractor {
    private static final String[] CPPCHECK_COMMAND_WITH_ARGUMENTS = new String[]{"cppcheck", "--errorlist", "--xml-version=2"};
    private static final Map<ECppcheckSeverity, EFindingEnablement> DEFAULT_ENABLEMENTS = new HashMap<ECppcheckSeverity, EFindingEnablement>();

    public static void main(String ... arguments) {
        File outputFile;
        if (arguments.length > 2 || arguments.length <= 0) {
            CppCheckRulesExtractor.exitWithError("Tool expects an optional input XML file and an output file as parameters.");
        }
        File inputFile = null;
        if (arguments.length == 2) {
            inputFile = new File(arguments[0]);
            outputFile = new File(arguments[1]);
        } else {
            outputFile = new File(arguments[0]);
        }
        if (outputFile.exists()) {
            CppCheckRulesExtractor.exitWithError("Output file already exists.");
        }
        try {
            CppCheckRulesExtractor.extractRulesJSON(inputFile, outputFile);
        }
        catch (ConQATException e) {
            CppCheckRulesExtractor.exitWithError(e.toString());
        }
    }

    private static void exitWithError(String message) {
        System.err.println(message);
        System.exit(1);
    }

    private static void extractRulesJSON(File inputFile, File outputFile) throws ConQATException {
        String errorListXML;
        if (inputFile != null) {
            try {
                errorListXML = FileSystemUtils.readFileUTF8((File)inputFile);
            }
            catch (IOException e) {
                throw new ConQATException("Error when reading file.", (Throwable)e);
            }
        } else {
            errorListXML = CppCheckRulesExtractor.readFromCppcheckCommand();
        }
        List<Rule> rules = CppCheckRulesExtractor.extractRules(errorListXML);
        try {
            for (Rule rule : rules) {
                String description = rule.description;
                rule.description = "";
                FileSystemUtils.writeFileUTF8((Path)outputFile.getParentFile().toPath().resolve("check-descriptions/cppcheck/" + rule.id + ".md"), (String)description);
            }
            String prettyPrintedJson = JsonUtils.serializeToJSONPrettyPrinted(rules);
            FileSystemUtils.writeFileUTF8((File)outputFile, (String)prettyPrintedJson);
        }
        catch (IOException | ConQATException e) {
            throw new ConQATException("Error when writing JSON.", e);
        }
    }

    private static String readFromCppcheckCommand() throws ConQATException {
        try {
            ProcessUtils.ExecutionResult executionResult = ProcessUtils.execute((ProcessBuilder)new ProcessBuilder(CPPCHECK_COMMAND_WITH_ARGUMENTS), null, (long)5L, (boolean)true);
            if (executionResult.terminatedByTimeoutOrInterruption()) {
                throw new ConQATException("Console command took too long. Destroying process forcibly.");
            }
            if (executionResult.getReturnCode() == 0) {
                return executionResult.getStdout();
            }
            throw new ConQATException("Error when executing cppcheck on console.\nOutput:\n" + executionResult.getStderr());
        }
        catch (IOException e) {
            throw new ConQATException("Error when executing cppcheck on console.", (Throwable)e);
        }
    }

    private static List<Rule> extractRules(String errorListXML) throws ConQATException {
        try {
            CppcheckResults results = (CppcheckResults)XmlSerializationUtils.deserializeFromXML((String)errorListXML, CppcheckResults.class);
            Collections.sort(results.getErrors());
            return results.getErrors().stream().map(CppCheckRulesExtractor::createRule).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new ConQATException("Error when parsing XML.", (Throwable)e);
        }
    }

    private static Rule createRule(CppcheckError error) {
        Rule result = new Rule();
        EFindingEnablement enablement = DEFAULT_ENABLEMENTS.get((Object)error.getSeverity());
        result.id = error.getId();
        result.message = error.getMessage();
        result.description = error.getVerboseMessage();
        result.severity = enablement.toString();
        result.category = error.getSeverity().getAnalysisGroupName();
        return result;
    }

    static {
        DEFAULT_ENABLEMENTS.put(ECppcheckSeverity.ERROR, EFindingEnablement.RED);
        DEFAULT_ENABLEMENTS.put(ECppcheckSeverity.WARNING, EFindingEnablement.YELLOW);
        DEFAULT_ENABLEMENTS.put(ECppcheckSeverity.STYLE, EFindingEnablement.YELLOW);
        DEFAULT_ENABLEMENTS.put(ECppcheckSeverity.PERFORMANCE, EFindingEnablement.OFF);
        DEFAULT_ENABLEMENTS.put(ECppcheckSeverity.PORTABILITY, EFindingEnablement.OFF);
        DEFAULT_ENABLEMENTS.put(ECppcheckSeverity.INFORMATION, EFindingEnablement.OFF);
        DEFAULT_ENABLEMENTS.put(ECppcheckSeverity.UNKNOWN, EFindingEnablement.OFF);
    }
}

