/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.utils;

import com.teamscale.commons.utils.StringPool;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class StringPoolDeserializer {
    private final List<String> stringPool = new ArrayList<String>();

    public void deserialize(byte[] data) {
        try (DataInputStream din = new DataInputStream(new ByteArrayInputStream(data));){
            this.deserializeStringPool(din);
            this.deserializeData(din);
        }
        catch (IOException e) {
            throw new AssertionError("Working in memory should not allow this!", e);
        }
    }

    private void deserializeStringPool(DataInputStream din) throws IOException {
        int stringPoolSize = din.readInt();
        for (int i = 0; i < stringPoolSize; ++i) {
            this.stringPool.add(StringPool.intern((String)din.readUTF()));
        }
    }

    protected abstract void deserializeData(DataInputStream var1) throws IOException;

    protected String readString(DataInputStream din) throws IOException {
        int index = din.readInt();
        if (index == -1) {
            return null;
        }
        return this.stringPool.get(index);
    }
}

