/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.internal.apachecommons.lang3.builder.ToStringBuilder;
import org.sonar.api.internal.apachecommons.lang3.builder.ToStringStyle;
import org.sonar.api.utils.log.Logger;

public final class ValidationMessages {
    private List<String> errors = new ArrayList<String>();
    private List<String> warnings = new ArrayList<String>();
    private List<String> infos = new ArrayList<String>();

    ValidationMessages() {
    }

    public static ValidationMessages create() {
        return new ValidationMessages();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public ValidationMessages addErrorText(String text) {
        this.errors.add(text);
        return this;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public ValidationMessages addWarningText(String text) {
        this.warnings.add(text);
        return this;
    }

    public List<String> getInfos() {
        return this.infos;
    }

    public boolean hasInfos() {
        return !this.infos.isEmpty();
    }

    public ValidationMessages addInfoText(String text) {
        this.infos.add(text);
        return this;
    }

    public void log(Logger logger) {
        for (String error : this.getErrors()) {
            logger.error(error);
        }
        for (String warning : this.getWarnings()) {
            logger.warn(warning);
        }
        for (String info : this.getInfos()) {
            logger.info(info);
        }
    }

    @Deprecated
    public void log(org.slf4j.Logger logger) {
        for (String error : this.getErrors()) {
            logger.error(error);
        }
        for (String warning : this.getWarnings()) {
            logger.warn(warning);
        }
        for (String info : this.getInfos()) {
            logger.info(info);
        }
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("errors", this.errors).append("warnings", this.warnings).append("infos", this.infos).toString();
    }
}

