/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.cache.SerializationResult;
import org.sonar.php.cache.StringTable;
import org.sonar.php.cache.SymbolTableSerializationInput;
import org.sonar.php.cache.VarLengthOutputStream;
import org.sonar.php.symbols.ClassSymbolData;
import org.sonar.php.symbols.FunctionSymbolData;
import org.sonar.php.symbols.MethodSymbolData;
import org.sonar.php.symbols.Parameter;
import org.sonar.php.tree.symbols.SymbolQualifiedName;
import org.sonar.php.tree.symbols.SymbolTableImpl;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.symbols.ReturnType;
import org.sonar.plugins.php.api.visitors.LocationInFile;

public class SymbolTableSerializer {
    private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private final VarLengthOutputStream out = new VarLengthOutputStream(this.stream);
    private final StringTable stringTable = new StringTable();

    private SymbolTableSerializer() {
    }

    public static SerializationResult toBinary(SymbolTableSerializationInput serializationInput) {
        SymbolTableSerializer serializer = new SymbolTableSerializer();
        return serializer.convert(serializationInput);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private SerializationResult convert(SymbolTableSerializationInput symbolTableSerializationInput) {
        try (VarLengthOutputStream varLengthOutputStream = this.out;){
            SerializationResult serializationResult;
            block16: {
                ByteArrayOutputStream byteArrayOutputStream = this.stream;
                try {
                    String pluginVersion = symbolTableSerializationInput.pluginVersion();
                    this.writeText(pluginVersion);
                    SymbolTableImpl projectSymbolData = symbolTableSerializationInput.symbolTable();
                    Collection<ClassSymbolData> classSymbols = projectSymbolData.classSymbolDatas();
                    this.writeInt(classSymbols.size());
                    for (ClassSymbolData classSymbol : classSymbols) {
                        this.write(classSymbol);
                    }
                    Collection<FunctionSymbolData> nameFuncSymbolData = projectSymbolData.functionSymbolDatas();
                    this.writeInt(nameFuncSymbolData.size());
                    for (FunctionSymbolData value : nameFuncSymbolData) {
                        this.write(value);
                    }
                    this.out.writeUTF("END");
                    serializationResult = new SerializationResult(this.stream.toByteArray(), this.writeStringTable());
                    if (byteArrayOutputStream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                byteArrayOutputStream.close();
            }
            return serializationResult;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't store data in cache", e);
        }
    }

    private void write(QualifiedName qualifiedName) throws IOException {
        if (!(qualifiedName instanceof SymbolQualifiedName)) {
            throw new IllegalStateException("The QualifiedName of type " + qualifiedName.getClass().getSimpleName() + " is not supported");
        }
        this.writeText(qualifiedName.toString());
    }

    private void write(ClassSymbolData classSymbolData) throws IOException {
        LocationInFile location = classSymbolData.location();
        this.write(location);
        this.write(classSymbolData.qualifiedName());
        this.writeText(classSymbolData.superClass().map(Object::toString).orElse(""));
        this.writeInt(classSymbolData.implementedInterfaces().size());
        for (QualifiedName implementedInterface : classSymbolData.implementedInterfaces()) {
            this.write(implementedInterface);
        }
        this.writeText(classSymbolData.kind().name());
        this.writeInt(classSymbolData.methods().size());
        for (MethodSymbolData method : classSymbolData.methods()) {
            this.write(method);
        }
    }

    private void write(MethodSymbolData method) throws IOException {
        this.writeText(method.visibility().toString());
        this.writeText(method.name());
        this.writeBoolean(method.isAbstract());
        this.writeBoolean(method.isTestMethod());
        this.write(method.location());
        this.writeParameters(method.parameters());
        this.writeBoolean(method.properties().hasReturn());
        this.writeBoolean(method.properties().hasFuncGetArgs());
        this.write(method.returnType());
    }

    private void writeParameters(List<Parameter> parameters) throws IOException {
        this.writeInt(parameters.size());
        for (Parameter parameter : parameters) {
            this.writeText(parameter.name());
            this.writeText(parameter.type());
            this.writeBoolean(parameter.hasDefault());
            this.writeBoolean(parameter.hasEllipsisOperator());
        }
    }

    private void write(LocationInFile location) throws IOException {
        String filePath = location.filePath();
        if ("[unknown file]".equals(filePath)) {
            this.writeText(filePath);
        } else {
            this.writeText(filePath);
            this.writeInt(location.startLine());
            this.writeInt(location.startLineOffset());
            this.writeInt(location.endLine());
            this.writeInt(location.endLineOffset());
        }
    }

    private void write(FunctionSymbolData data) throws IOException {
        if (data instanceof MethodSymbolData) {
            throw new IllegalStateException("The FunctionSymbolData of type " + data.getClass().getName() + " is not supported");
        }
        this.write(data.location());
        this.write(data.qualifiedName());
        this.writeParameters(data.parameters());
        this.write(data.properties());
        this.write(data.returnType());
    }

    private void write(FunctionSymbolData.FunctionSymbolProperties properties) throws IOException {
        this.writeBoolean(properties.hasReturn());
        this.writeBoolean(properties.hasFuncGetArgs());
    }

    private void write(ReturnType returnType) throws IOException {
        this.writeBoolean(returnType.isPresent());
        this.writeBoolean(returnType.isVoid());
    }

    private void writeText(@Nullable String text) throws IOException {
        this.out.writeInt(this.stringTable.getIndex(text));
    }

    private void writeInt(int number) throws IOException {
        this.out.writeInt(number);
    }

    private void writeBoolean(boolean bool) throws IOException {
        this.out.writeBoolean(bool);
    }

    private byte[] writeStringTable() throws IOException {
        ByteArrayOutputStream stringTableStream = new ByteArrayOutputStream();
        VarLengthOutputStream output = new VarLengthOutputStream(stringTableStream);
        List<String> byIndex = this.stringTable.getStringList();
        output.writeInt(byIndex.size());
        for (String string : byIndex) {
            output.writeUTF(string);
        }
        output.writeUTF("END");
        return stringTableStream.toByteArray();
    }
}

