/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1600")
public class DeprecatedPredefinedVariablesUseCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1600";
    private static final String MESSAGE = "Replace this use of the deprecated \"%s\" variable with \"%s\".";

    @Override
    public void visitVariableIdentifier(VariableIdentifierTree tree) {
        this.checkVariable(tree.variableExpression().token());
        super.visitVariableIdentifier(tree);
    }

    private void checkVariable(SyntaxToken variable) {
        String name = variable.text();
        if (CheckUtils.getSuperGlobalsByOldName().containsKey(name)) {
            String replacement = CheckUtils.getSuperGlobalsByOldName().get(name);
            this.raiseIssue(variable, name, replacement);
        } else if ("$php_errormsg".equals(name)) {
            this.raiseIssue(variable, name, "error_get_last()");
        }
    }

    private void raiseIssue(SyntaxToken variable, String deprecatedName, String suggestedReplacement) {
        String message = String.format(MESSAGE, deprecatedName, suggestedReplacement);
        this.context().newIssue(this, variable, message);
    }

    @Override
    public void visitMemberAccess(MemberAccessTree tree) {
    }
}

