/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.php.api.PHPKeyword;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.MatchExpressionTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1781")
public class KeywordsAndConstantsNotLowerCaseCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1781";
    private static final String MESSAGE = "Write this \"%s\" %s in %s case.";
    private static final Pattern PATTERN = Pattern.compile("[a-z_]+");
    private static final Pattern PATTERN_DRUPAL = Pattern.compile("[A-Z_]+");
    private static final Set<String> KEYWORDS = Set.of(PHPKeyword.getKeywordValues());

    @Override
    public void visitLiteral(LiteralTree tree) {
        super.visitLiteral(tree);
        if (tree.is(Tree.Kind.NULL_LITERAL, Tree.Kind.BOOLEAN_LITERAL)) {
            if (this.context().getFramework() == SymbolTable.Framework.DRUPAL) {
                this.checkWithDrupalConvention(tree, tree.value(), "constant");
            } else {
                this.check(tree, tree.value(), "constant");
            }
        }
    }

    @Override
    public void visitToken(SyntaxToken token) {
        super.visitToken(token);
        if (token.text().toLowerCase(Locale.ENGLISH).equals("match")) {
            if (token.getParent() instanceof MatchExpressionTree) {
                this.check(token, token.text(), "keyword");
            }
        } else if (KEYWORDS.contains(token.text().toLowerCase(Locale.ENGLISH))) {
            this.check(token, token.text(), "keyword");
        }
    }

    @Override
    public void visitNameIdentifier(NameIdentifierTree tree) {
    }

    private void checkForFakeIdentifier(Tree tree) {
        if (tree.is(Tree.Kind.NAME_IDENTIFIER)) {
            this.visitToken(((NameIdentifierTree)tree).token());
        }
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        ExpressionTree callee = tree.callee();
        if (callee.is(Tree.Kind.NAMESPACE_NAME)) {
            NamespaceNameTree name = (NamespaceNameTree)callee;
            callee = name.name();
        }
        this.checkForFakeIdentifier(callee);
        super.visitFunctionCall(tree);
    }

    @Override
    public void visitMemberAccess(MemberAccessTree tree) {
        this.checkForFakeIdentifier(tree.object());
        super.visitMemberAccess(tree);
    }

    private void check(Tree tree, String value, String kind) {
        if (!PATTERN.matcher(value).matches()) {
            String message = MESSAGE.formatted(value, kind, "lower");
            this.context().newIssue(this, tree, message);
        }
    }

    private void checkWithDrupalConvention(Tree tree, String value, String kind) {
        if (!PATTERN_DRUPAL.matcher(value).matches()) {
            String message = MESSAGE.formatted(value, kind, "upper");
            this.context().newIssue(this, tree, message);
        }
    }
}

