/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.declaration.ClassPropertyDeclarationTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1766")
public class OnePropertyDeclarationPerStatementCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1766";
    private static final String MESSAGE = "%s property declarations were found in this statement. Reformat the code to declare only one property per statement.";

    @Override
    public void visitClassPropertyDeclaration(ClassPropertyDeclarationTree tree) {
        super.visitClassPropertyDeclaration(tree);
        int declarationsNumber = tree.declarations().size();
        if (declarationsNumber > 1) {
            String message = String.format(MESSAGE, declarationsNumber);
            this.context().newIssue(this, tree, message);
        }
    }
}

